/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GenerationInfoBase;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateGenerationInfo
extends GenerationInfoBase
implements GenerationInfo {
    private final Expression myExpression;
    private SmartPsiElementPointer<PsiMethod> myElement;

    public TemplateGenerationInfo(PsiMethod element, Expression expression) {
        this.setElement(element);
        this.myExpression = expression;
    }

    private void setElement(PsiMethod element) {
        this.myElement = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer((PsiElement)element);
    }

    protected abstract PsiElement getTemplateElement(PsiMethod var1);

    @NotNull
    public PsiMethod getPsiMember() {
        PsiMethod psiMethod = (PsiMethod)ObjectUtils.assertNotNull((Object)this.myElement.getElement());
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/TemplateGenerationInfo", "getPsiMember"));
        }
        return psiMethod;
    }

    @Override
    public void insert(@NotNull PsiClass aClass, PsiElement anchor, boolean before) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/generation/TemplateGenerationInfo", "insert"));
        }
        this.setElement((PsiMethod)GenerateMembersUtil.insert(aClass, (PsiMember)this.getPsiMember(), anchor, before));
    }

    public Template getTemplate() {
        PsiMethod element = this.getPsiMember();
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)element);
        builder.replaceElement(this.getTemplateElement(element), this.myExpression);
        return builder.buildTemplate();
    }
}

