/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.ChooseClassAndDoHighlightRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;

public class HighlightExceptionsHandler
extends HighlightUsagesHandlerBase<PsiClass> {
    private final PsiElement myTarget;
    private final PsiClassType[] myClassTypes;
    private final PsiElement myPlace;
    private final PsiElement myOtherPlace;
    private final Condition<PsiType> myTypeFilter;

    public HighlightExceptionsHandler(Editor editor, PsiFile file2, PsiElement target, PsiClassType[] classTypes, PsiElement place, PsiElement otherPlace, Condition<PsiType> typeFilter) {
        super(editor, file2);
        this.myTarget = target;
        this.myClassTypes = classTypes;
        this.myPlace = place;
        this.myOtherPlace = otherPlace;
        this.myTypeFilter = typeFilter;
    }

    @Override
    public List<PsiClass> getTargets() {
        return ChooseClassAndDoHighlightRunnable.resolveClasses(this.myClassTypes);
    }

    @Override
    protected void selectTargets(List<PsiClass> targets, final Consumer<List<PsiClass>> selectionConsumer) {
        new ChooseClassAndDoHighlightRunnable(this.myClassTypes, this.myEditor, CodeInsightBundle.message((String)"highlight.exceptions.thrown.chooser.title", (Object[])new Object[0])){

            protected void selected(PsiClass ... classes) {
                if (classes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/codeInsight/highlighting/HighlightExceptionsHandler$1", "selected"));
                }
                selectionConsumer.consume(Arrays.asList(classes));
            }
        }.run();
    }

    @Override
    public void computeUsages(List<PsiClass> targets) {
        this.addOccurrence(this.myTarget);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myEditor.getProject()).getElementFactory();
        for (PsiClass aClass : targets) {
            this.addExceptionThrowPlaces(factory.createType(aClass), this.myPlace);
            if (this.myOtherPlace == null) continue;
            this.addExceptionThrowPlaces(factory.createType(aClass), this.myOtherPlace);
        }
        this.buildStatusText(LangBundle.message("java.terms.exception", new Object[0]), this.myReadUsages.size() - 1);
    }

    private void addExceptionThrowPlaces(final PsiClassType type, final PsiElement place) {
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitThrowStatement(PsiThrowStatement statement2) {
                super.visitThrowStatement(statement2);
                List<PsiClassType> actualTypes = ExceptionUtil.getUnhandledExceptions(statement2, place);
                for (PsiClassType actualType : actualTypes) {
                    if (actualType == null || !type.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                    PsiExpression psiExpression = statement2.getException();
                    if (psiExpression instanceof PsiReferenceExpression) {
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)psiExpression);
                        continue;
                    }
                    if (psiExpression instanceof PsiNewExpression) {
                        PsiJavaCodeReferenceElement ref = ((PsiNewExpression)psiExpression).getClassReference();
                        if (ref == null) continue;
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)ref);
                        continue;
                    }
                    PsiExpression exception = statement2.getException();
                    if (exception == null) continue;
                    HighlightExceptionsHandler.this.addOccurrence((PsiElement)exception);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiReference reference = expression.getMethodExpression().getReference();
                if (reference != null) {
                    List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression, place);
                    for (PsiClassType actualType : exceptionTypes) {
                        if (!type.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)expression.getMethodExpression());
                        break;
                    }
                }
            }

            public void visitNewExpression(PsiNewExpression expression) {
                super.visitNewExpression(expression);
                PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                if (classReference != null) {
                    List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)expression, place);
                    for (PsiClassType actualType : exceptionTypes) {
                        if (!type.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                        HighlightExceptionsHandler.this.addOccurrence((PsiElement)classReference);
                        break;
                    }
                }
            }

            public void visitResourceExpression(PsiResourceExpression expression) {
                super.visitResourceExpression(expression);
                List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)expression, place);
                for (PsiClassType actualType : exceptionTypes) {
                    if (!type.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType)) continue;
                    HighlightExceptionsHandler.this.addOccurrence((PsiElement)expression);
                    break;
                }
            }

            public void visitResourceVariable(PsiResourceVariable variable) {
                super.visitResourceVariable(variable);
                List<PsiClassType> exceptionTypes = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)variable, place);
                for (PsiClassType actualType : exceptionTypes) {
                    PsiIdentifier name;
                    if (!type.isAssignableFrom((PsiType)actualType) || !HighlightExceptionsHandler.this.myTypeFilter.value((Object)actualType) || (name = variable.getNameIdentifier()) == null) continue;
                    HighlightExceptionsHandler.this.addOccurrence((PsiElement)name);
                    break;
                }
            }
        });
    }
}

