/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.ide.IdeTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class HintManagerImpl
extends HintManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.HintManager");
    private final AnActionListener myAnActionListener;
    private final MyEditorManagerListener myEditorManagerListener;
    private final EditorMouseAdapter myEditorMouseListener;
    private final FocusListener myEditorFocusListener;
    private final DocumentListener myEditorDocumentListener;
    private final VisibleAreaListener myVisibleAreaListener;
    private final CaretListener myCaretMoveListener;
    private LightweightHint myQuestionHint;
    private QuestionAction myQuestionAction;
    private final List<HintInfo> myHintsStack = new ArrayList<HintInfo>();
    private Editor myLastEditor;
    private final Alarm myHideAlarm = new Alarm();

    private static int getPriority(QuestionAction action) {
        return action instanceof PriorityQuestionAction ? ((PriorityQuestionAction)action).getPriority() : 0;
    }

    public boolean canShowQuestionAction(QuestionAction action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myQuestionAction == null || HintManagerImpl.getPriority(this.myQuestionAction) <= HintManagerImpl.getPriority(action);
    }

    public static HintManagerImpl getInstanceImpl() {
        return (HintManagerImpl)((Object)ServiceManager.getService(HintManager.class));
    }

    public HintManagerImpl(ActionManagerEx actionManagerEx, ProjectManager projectManager) {
        this.myEditorManagerListener = new MyEditorManagerListener();
        this.myAnActionListener = new MyAnActionListener();
        actionManagerEx.addAnActionListener(this.myAnActionListener);
        this.myCaretMoveListener = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                HintManagerImpl.this.hideHints(2, false, false);
            }
        };
        MyProjectManagerListener projectManagerListener = new MyProjectManagerListener();
        for (Project project2 : projectManager.getOpenProjects()) {
            projectManagerListener.projectOpened(project2);
        }
        projectManager.addProjectManagerListener((ProjectManagerListener)projectManagerListener);
        this.myEditorMouseListener = new EditorMouseAdapter(){

            public void mousePressed(EditorMouseEvent event) {
                HintManagerImpl.this.hideAllHints();
            }
        };
        this.myVisibleAreaListener = e -> {
            this.updateScrollableHints(e);
            if (e.getOldRectangle() == null || e.getOldRectangle().x != e.getNewRectangle().x || e.getOldRectangle().y != e.getNewRectangle().y) {
                this.hideHints(32, false, false);
            }
        };
        this.myEditorFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(final FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.addRequest(new Runnable(){
                    private boolean myNotFocused;

                    @Override
                    public void run() {
                        boolean notFocused;
                        boolean bl = notFocused = !JBPopupFactory.getInstance().isChildPopupFocused(e.getComponent());
                        if (this.myNotFocused && notFocused) {
                            HintManagerImpl.this.hideAllHints();
                        }
                        this.myNotFocused = notFocused;
                    }
                }, 200);
            }

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        };
        this.myEditorDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                HintInfo[] infos;
                LOG.assertTrue(SwingUtilities.isEventDispatchThread());
                if (event.getOldLength() == 0 && event.getNewLength() == 0) {
                    return;
                }
                for (HintInfo info : infos = HintManagerImpl.this.getHintsStackArray()) {
                    if (!BitUtil.isSet((int)info.flags, (int)8)) continue;
                    if (info.hint.isVisible()) {
                        info.hint.hide();
                    }
                    HintManagerImpl.this.myHintsStack.remove(info);
                }
                if (HintManagerImpl.this.myHintsStack.isEmpty()) {
                    HintManagerImpl.this.updateLastEditor(null);
                }
            }
        };
    }

    public boolean isHint(Window component) {
        return this.myHintsStack.contains(component);
    }

    @NotNull
    private HintInfo[] getHintsStackArray() {
        HintInfo[] hintInfoArray = this.myHintsStack.toArray(new HintInfo[this.myHintsStack.size()]);
        if (hintInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintsStackArray"));
        }
        return hintInfoArray;
    }

    public boolean performCurrentQuestionAction() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQuestionAction != null && this.myQuestionHint != null) {
            if (this.myQuestionHint.isVisible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("performing an action:" + this.myQuestionAction);
                }
                if (this.myQuestionAction.execute() && this.myQuestionHint != null) {
                    this.myQuestionHint.hide();
                }
                return true;
            }
            this.myQuestionAction = null;
            this.myQuestionHint = null;
        }
        return false;
    }

    private void updateScrollableHints(VisibleAreaEvent e) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo info : this.getHintsStackArray()) {
            if (info.hint == null || !BitUtil.isSet((int)info.flags, (int)128)) continue;
            HintManagerImpl.updateScrollableHintPosition(e, info.hint, BitUtil.isSet((int)info.flags, (int)64));
        }
    }

    public boolean hasShownHintsThatWillHideByOtherHint(boolean willShowTooltip) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo hintInfo : this.getHintsStackArray()) {
            if (hintInfo.hint.isVisible() && BitUtil.isSet((int)hintInfo.flags, (int)16)) {
                return true;
            }
            if (!willShowTooltip || !hintInfo.hint.isAwtTooltip()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        ActionManagerEx.getInstanceEx().removeAnActionListener(this.myAnActionListener);
    }

    private static void updateScrollableHintPosition(VisibleAreaEvent e, LightweightHint hint, boolean hideIfOutOfEditor) {
        boolean okToUpdateBounds;
        if (hint.getComponent() instanceof ScrollAwareHint) {
            ((ScrollAwareHint)((Object)hint.getComponent())).editorScrolled();
        }
        if (!hint.isVisible()) {
            return;
        }
        Editor editor = e.getEditor();
        if (!editor.getComponent().isShowing() || editor.isOneLineMode()) {
            return;
        }
        Rectangle newRectangle = e.getOldRectangle();
        Rectangle oldRectangle = e.getNewRectangle();
        Point location = hint.getLocationOn(editor.getContentComponent());
        Dimension size = hint.getSize();
        int xOffset = location.x - oldRectangle.x;
        int yOffset = location.y - oldRectangle.y;
        location = new Point(newRectangle.x + xOffset, newRectangle.y + yOffset);
        Rectangle newBounds = new Rectangle(location.x, location.y, size.width, size.height);
        boolean bl = okToUpdateBounds = hideIfOutOfEditor ? oldRectangle.contains(newBounds) : oldRectangle.intersects(newBounds);
        if (okToUpdateBounds || hint.vetoesHiding()) {
            hint.setLocation(new RelativePoint((Component)editor.getContentComponent(), location));
        } else {
            hint.hide();
        }
    }

    public void showEditorHint(LightweightHint hint, Editor editor, @HintManager.PositionFlags short constraint, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        editor.getScrollingModel().runActionOnScrollingFinished(() -> {
            LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
            Point p = HintManagerImpl.getHintPosition(hint, editor, pos, constraint);
            this.showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange, HintManagerImpl.createHintHint(editor, p, hint, constraint));
        });
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        this.showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange, (short)1);
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, @HintManager.PositionFlags short position) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        this.showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange, HintManagerImpl.createHintHint(editor, p, hint, position));
    }

    public void showEditorHint(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange, HintHint hintInfo) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/HintManagerImpl", "showEditorHint"));
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        if (editor != this.myLastEditor) {
            this.hideAllHints();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
            return;
        }
        if (!ApplicationManager.getApplication().isActive()) {
            return;
        }
        this.updateLastEditor(editor);
        HintManagerImpl.getPublisher().hintShown(editor.getProject(), hint, flags);
        JComponent component = hint.getComponent();
        if (ScreenReader.isActive()) {
            hintInfo.setRequestFocus(true);
        }
        HintManagerImpl.doShowInGivenLocation(hint, editor, p, hintInfo, true);
        ListenerUtil.addMouseListener(component, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        if (BitUtil.isSet((int)flags, (int)256)) {
            ListenerUtil.addMouseMotionListener(component, new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    HintManagerImpl.this.hideHints(256, true, false);
                }
            });
        }
        this.myHintsStack.add(new HintInfo(hint, flags, reviveOnEditorChange));
        if (timeout > 0) {
            Timer timer = UIUtil.createNamedTimer((String)"Hint timeout", (int)timeout, event -> {
                if (hint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "lambda$showEditorHint$2"));
                }
                hint.hide();
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    public void showHint(@NotNull JComponent component, @NotNull RelativePoint p, int flags, int timeout) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/codeInsight/hint/HintManagerImpl", "showHint"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/HintManagerImpl", "showHint"));
        }
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.myHideAlarm.cancelAllRequests();
        this.hideHints(16, false, false);
        final JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(component, null).setRequestFocus(false).setResizable(false).setMovable(false).createPopup();
        popup.show(p);
        ListenerUtil.addMouseListener(component, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        ListenerUtil.addFocusListener(component, new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                HintManagerImpl.this.myHideAlarm.cancelAllRequests();
            }
        });
        HintInfo info = new HintInfo(new LightweightHint(component){

            @Override
            public void hide() {
                popup.cancel();
            }
        }, flags, false);
        this.myHintsStack.add(info);
        if (timeout > 0) {
            Timer timer = UIUtil.createNamedTimer((String)"Popup timeout", (int)timeout, event -> Disposer.dispose((Disposable)popup));
            timer.setRepeats(false);
            timer.start();
        }
    }

    private static void doShowInGivenLocation(LightweightHint hint, Editor editor, Point p, HintHint hintInfo, boolean updateSize) {
        Dimension size;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        Dimension dimension = size = updateSize ? hint.getComponent().getPreferredSize() : hint.getComponent().getSize();
        if (hint.isRealPopup()) {
            Point editorCorner = editor.getComponent().getLocation();
            SwingUtilities.convertPointToScreen(editorCorner, externalComponent);
            Point point = new Point(p);
            SwingUtilities.convertPointToScreen(point, externalComponent);
            Rectangle editorScreen = ScreenUtil.getScreenRectangle((int)point.x, (int)point.y);
            SwingUtilities.convertPointToScreen(p, externalComponent);
            Rectangle rectangle = new Rectangle(p, size);
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)editorScreen, null);
            p = rectangle.getLocation();
            SwingUtilities.convertPointFromScreen(p, externalComponent);
        } else if (externalComponent.getWidth() < p.x + size.width && !hintInfo.isAwtTooltip()) {
            p.x = Math.max(0, externalComponent.getWidth() - size.width);
        }
        if (hint.isVisible()) {
            if (updateSize) {
                hint.pack();
            }
            hint.updatePosition(hintInfo.getPreferredPosition());
            hint.updateLocation(p.x, p.y);
        } else {
            hint.show(externalComponent, p.x, p.y, editor.getContentComponent(), hintInfo);
        }
    }

    public static void updateLocation(LightweightHint hint, Editor editor, Point p) {
        HintManagerImpl.doShowInGivenLocation(hint, editor, p, HintManagerImpl.createHintHint(editor, p, hint, (short)2), false);
    }

    public static void adjustEditorHintPosition(LightweightHint hint, Editor editor, Point p, @HintManager.PositionFlags short constraint) {
        HintManagerImpl.doShowInGivenLocation(hint, editor, p, HintManagerImpl.createHintHint(editor, p, hint, constraint), true);
    }

    public void hideAllHints() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (HintInfo info : this.getHintsStackArray()) {
            if (info.hint.vetoesHiding()) continue;
            info.hint.hide();
        }
        this.cleanup();
    }

    public void cleanup() {
        this.myHintsStack.clear();
        this.updateLastEditor(null);
    }

    public Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        DataContext dataContext = ((EditorEx)editor).getDataContext();
        Rectangle dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext);
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        if (dominantArea != null) {
            return HintManagerImpl.getHintPositionRelativeTo(hint, editor, constraint, dominantArea, pos);
        }
        JRootPane rootPane = editor.getComponent().getRootPane();
        if (rootPane != null) {
            JLayeredPane lp = rootPane.getLayeredPane();
            for (HintInfo info : this.getHintsStackArray()) {
                if (!info.hint.isSelectingHint()) continue;
                IdeTooltip tooltip = info.hint.getCurrentIdeTooltip();
                if (tooltip != null) {
                    Point p = tooltip.getShowingPoint().getPoint((Component)lp);
                    if (info.hint != hint) {
                        switch (constraint) {
                            case 1: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.below) break;
                                p.y -= tooltip.getPositionChangeY();
                                break;
                            }
                            case 2: 
                            case 5: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.above) break;
                                p.y += tooltip.getPositionChangeY();
                                break;
                            }
                            case 4: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.atLeft) break;
                                p.x += tooltip.getPositionChangeX();
                                break;
                            }
                            case 3: {
                                if (tooltip.getPreferredPosition() != Balloon.Position.atRight) break;
                                p.x -= tooltip.getPositionChangeX();
                            }
                        }
                    }
                    return p;
                }
                Rectangle rectangle = info.hint.getBounds();
                JComponent c = info.hint.getComponent();
                rectangle = SwingUtilities.convertRectangle(c.getParent(), rectangle, lp);
                return HintManagerImpl.getHintPositionRelativeTo(hint, editor, constraint, rectangle, pos);
            }
        }
        return HintManagerImpl.getHintPosition(hint, editor, pos, constraint);
    }

    private static Point getHintPositionRelativeTo(@NotNull LightweightHint hint, @NotNull Editor editor, @HintManager.PositionFlags short constraint, @NotNull Rectangle lookupBounds, LogicalPosition pos) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPositionRelativeTo"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPositionRelativeTo"));
        }
        if (lookupBounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupBounds", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPositionRelativeTo"));
        }
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        IdeTooltip ideTooltip = hint.getCurrentIdeTooltip();
        if (ideTooltip != null) {
            Point point = ideTooltip.getPoint();
            return SwingUtilities.convertPoint(ideTooltip.getComponent(), point, externalComponent);
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        int layeredPaneHeight = externalComponent.getHeight();
        switch (constraint) {
            case 3: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x - hintSize.width, y);
            }
            case 4: {
                int y = lookupBounds.y;
                if (y < 0) {
                    y = 0;
                } else if (y + hintSize.height >= layeredPaneHeight) {
                    y = layeredPaneHeight - hintSize.height;
                }
                return new Point(lookupBounds.x + lookupBounds.width, y);
            }
            case 1: {
                Point posAboveCaret = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
                return new Point(lookupBounds.x, Math.min(posAboveCaret.y, lookupBounds.y - hintSize.height));
            }
            case 2: {
                Point posUnderCaret = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
                return new Point(lookupBounds.x, Math.max(posUnderCaret.y, lookupBounds.y + lookupBounds.height));
            }
        }
        LOG.error("");
        return null;
    }

    public static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull LogicalPosition pos, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        return HintManagerImpl.getHintPosition(hint, editor, pos, pos, constraint);
    }

    private static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull LogicalPosition pos1, @NotNull LogicalPosition pos2, @HintManager.PositionFlags short constraint) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (pos1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos1", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (pos2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos2", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        return HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint, Registry.is((String)"editor.balloonHints"));
    }

    private static Point getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull LogicalPosition pos1, @NotNull LogicalPosition pos2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (pos1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos1", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (pos2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos2", "com/intellij/codeInsight/hint/HintManagerImpl", "getHintPosition"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new Point();
        }
        Point p = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, constraint, showByBalloon);
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        Dimension hintSize = hint.getComponent().getPreferredSize();
        if (constraint == 1) {
            if (p.y < 0) {
                Point p1 = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, (short)2, showByBalloon);
                if (p1.y + hintSize.height <= externalComponent.getSize().height) {
                    return p1;
                }
            }
        } else if (constraint == 2 && p.y + hintSize.height > externalComponent.getSize().height) {
            Point p1 = HintManagerImpl._getHintPosition(hint, editor, pos1, pos2, (short)1, showByBalloon);
            if (p1.y >= 0) {
                return p1;
            }
        }
        return p;
    }

    @NotNull
    public static JComponent getExternalComponent(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "getExternalComponent"));
        }
        JComponent externalComponent = editor.getComponent();
        JRootPane rootPane = externalComponent.getRootPane();
        if (rootPane == null) {
            JComponent jComponent = externalComponent;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintManagerImpl", "getExternalComponent"));
            }
            return jComponent;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        JComponent jComponent = layeredPane != null ? layeredPane : rootPane;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/HintManagerImpl", "getExternalComponent"));
        }
        return jComponent;
    }

    private static Point _getHintPosition(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull LogicalPosition pos1, @NotNull LogicalPosition pos2, @HintManager.PositionFlags short constraint, boolean showByBalloon) {
        Point location;
        Point p;
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "_getHintPosition"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "_getHintPosition"));
        }
        if (pos1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos1", "com/intellij/codeInsight/hint/HintManagerImpl", "_getHintPosition"));
        }
        if (pos2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos2", "com/intellij/codeInsight/hint/HintManagerImpl", "_getHintPosition"));
        }
        Dimension hintSize = hint.getComponent().getPreferredSize();
        int line1 = pos1.line;
        int col1 = pos1.column;
        int line2 = pos2.line;
        int col2 = pos2.column;
        JComponent externalComponent = HintManagerImpl.getExternalComponent(editor);
        JComponent internalComponent = editor.getContentComponent();
        if (constraint == 5) {
            p = editor.logicalPositionToXY(new LogicalPosition(line2, col2));
            if (!showByBalloon) {
                p.y += editor.getLineHeight();
            }
            location = SwingUtilities.convertPoint(internalComponent, p, externalComponent);
        } else {
            p = editor.logicalPositionToXY(new LogicalPosition(line1, col1));
            if (constraint == 2) {
                p.y += editor.getLineHeight();
            }
            location = SwingUtilities.convertPoint(internalComponent, p, externalComponent);
        }
        if (constraint == 1 && !showByBalloon) {
            location.y -= hintSize.height;
            int diff = location.x + hintSize.width - externalComponent.getWidth();
            if (diff > 0) {
                location.x = Math.max(location.x - diff, 0);
            }
        }
        if (!(constraint != 3 && constraint != 4 || showByBalloon)) {
            location.y -= hintSize.height / 2;
            if (constraint == 3) {
                location.x -= hintSize.width;
            }
        }
        return location;
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String text) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showErrorHint"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintManagerImpl", "showErrorHint"));
        }
        this.showErrorHint(editor, text, (short)1);
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String text, short position) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showErrorHint"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintManagerImpl", "showErrorHint"));
        }
        JComponent label = HintUtil.createErrorLabel(text);
        LightweightHint hint = new LightweightHint(label);
        Point p = this.getHintPosition(hint, editor, position);
        this.showEditorHint(hint, editor, p, 42, 0, false, position);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull String text) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showInformationHint"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/HintManagerImpl", "showInformationHint"));
        }
        JComponent label = HintUtil.createInformationLabel(text);
        this.showInformationHint(editor, label);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showInformationHint"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/codeInsight/hint/HintManagerImpl", "showInformationHint"));
        }
        AccessibleContextUtil.setName((JComponent)component, (String)"Hint");
        this.showInformationHint(editor, component, true);
    }

    public void showInformationHint(@NotNull Editor editor, @NotNull JComponent component, boolean showByBalloon) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showInformationHint"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/codeInsight/hint/HintManagerImpl", "showInformationHint"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LightweightHint hint = new LightweightHint(component);
        Point p = this.getHintPosition(hint, editor, (short)1);
        this.showEditorHint(hint, editor, p, 42, 0, false);
    }

    public void showErrorHint(@NotNull Editor editor, @NotNull String hintText, int offset1, int offset2, short constraint, int flags, int timeout) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showErrorHint"));
        }
        if (hintText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintText", "com/intellij/codeInsight/hint/HintManagerImpl", "showErrorHint"));
        }
        JComponent label = HintUtil.createErrorLabel(hintText);
        LightweightHint hint = new LightweightHint(label);
        LogicalPosition pos1 = editor.offsetToLogicalPosition(offset1);
        LogicalPosition pos2 = editor.offsetToLogicalPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint);
        this.showEditorHint(hint, editor, p, flags, timeout, false);
    }

    public void showQuestionHint(@NotNull Editor editor, @NotNull String hintText, int offset1, int offset2, @NotNull QuestionAction action) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        if (hintText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintText", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        JComponent label = HintUtil.createQuestionLabel(hintText);
        LightweightHint hint = new LightweightHint(label);
        this.showQuestionHint(editor, offset1, offset2, hint, action, (short)1);
    }

    public void showQuestionHint(@NotNull Editor editor, int offset1, int offset2, @NotNull LightweightHint hint, @NotNull QuestionAction action, @HintManager.PositionFlags short constraint) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        LogicalPosition pos1 = editor.offsetToLogicalPosition(offset1);
        LogicalPosition pos2 = editor.offsetToLogicalPosition(offset2);
        Point p = HintManagerImpl.getHintPosition(hint, editor, pos1, pos2, constraint);
        this.showQuestionHint(editor, p, offset1, offset2, hint, action, constraint);
    }

    public void showQuestionHint(@NotNull Editor editor, @NotNull Point p, int offset1, int offset2, final @NotNull LightweightHint hint, @NotNull QuestionAction action, @HintManager.PositionFlags short constraint) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/hint/HintManagerImpl", "showQuestionHint"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.hideQuestionHint();
        TextAttributes attributes = new TextAttributes();
        attributes.setEffectColor(HintUtil.QUESTION_UNDERSCORE_COLOR);
        attributes.setEffectType(EffectType.LINE_UNDERSCORE);
        final RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5001, attributes, HighlighterTargetArea.EXACT_RANGE);
        hint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                hint.removeHintListener(this);
                highlighter.dispose();
                if (HintManagerImpl.this.myQuestionHint == hint) {
                    HintManagerImpl.this.myQuestionAction = null;
                    HintManagerImpl.this.myQuestionHint = null;
                }
            }
        });
        this.showEditorHint(hint, editor, p, 714, 0, false, HintManagerImpl.createHintHint(editor, p, hint, constraint));
        this.myQuestionAction = action;
        this.myQuestionHint = hint;
    }

    private void hideQuestionHint() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQuestionHint != null) {
            this.myQuestionHint.hide();
            this.myQuestionHint = null;
            this.myQuestionAction = null;
        }
    }

    public static HintHint createHintHint(Editor editor, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint) {
        return HintManagerImpl.createHintHint(editor, p, hint, constraint, false);
    }

    public static HintHint createHintHint(Editor editor, Point p, LightweightHint hint, @HintManager.PositionFlags short constraint, boolean createInEditorComponent) {
        JRootPane rootPane = editor.getComponent().getRootPane();
        if (rootPane == null) {
            return new HintHint(editor, p);
        }
        JLayeredPane lp = rootPane.getLayeredPane();
        HintHint hintInfo = new HintHint(editor, SwingUtilities.convertPoint(lp, p, editor.getContentComponent()));
        boolean showByBalloon = Registry.is((String)"editor.balloonHints");
        if (showByBalloon) {
            if (!createInEditorComponent) {
                hintInfo = new HintHint(lp, p);
            }
            hintInfo.setAwtTooltip(true).setHighlighterType(true);
        }
        hintInfo.initStyleFrom(hint.getComponent());
        if (showByBalloon) {
            hintInfo.setBorderColor((Color)new JBColor(Color.gray, (Color)Gray._140));
            hintInfo.setFont(hintInfo.getTextFont().deriveFont(0));
            hintInfo.setCalloutShift((int)((double)editor.getLineHeight() * 0.1));
        }
        hintInfo.setPreferredPosition(Balloon.Position.above);
        if (constraint == 2 || constraint == 5) {
            hintInfo.setPreferredPosition(Balloon.Position.below);
        } else if (constraint == 4) {
            hintInfo.setPreferredPosition(Balloon.Position.atRight);
        } else if (constraint == 3) {
            hintInfo.setPreferredPosition(Balloon.Position.atLeft);
        }
        if (hint.isAwtTooltip()) {
            hintInfo.setAwtTooltip(true);
        }
        hintInfo.setPositionChangeShift(0, editor.getLineHeight());
        return hintInfo;
    }

    private void updateLastEditor(Editor editor) {
        if (this.myLastEditor != editor) {
            if (this.myLastEditor != null) {
                this.myLastEditor.removeEditorMouseListener((EditorMouseListener)this.myEditorMouseListener);
                this.myLastEditor.getContentComponent().removeFocusListener(this.myEditorFocusListener);
                this.myLastEditor.getDocument().removeDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().removeCaretListener(this.myCaretMoveListener);
            }
            this.myLastEditor = editor;
            if (this.myLastEditor != null) {
                this.myLastEditor.addEditorMouseListener((EditorMouseListener)this.myEditorMouseListener);
                this.myLastEditor.getContentComponent().addFocusListener(this.myEditorFocusListener);
                this.myLastEditor.getDocument().addDocumentListener(this.myEditorDocumentListener);
                this.myLastEditor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
                this.myLastEditor.getCaretModel().addCaretListener(this.myCaretMoveListener);
            }
        }
    }

    boolean isEscapeHandlerEnabled() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        for (int i2 = this.myHintsStack.size() - 1; i2 >= 0; --i2) {
            HintInfo info = this.myHintsStack.get(i2);
            if (!info.hint.isVisible()) {
                this.myHintsStack.remove(i2);
                info.hint.hide();
                continue;
            }
            if ((info.flags & 3) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hideHints(int mask, boolean onlyOne, boolean editorChanged) {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        try {
            boolean done2 = false;
            for (int i2 = this.myHintsStack.size() - 1; i2 >= 0; --i2) {
                HintInfo info = this.myHintsStack.get(i2);
                if (!info.hint.isVisible() && !info.hint.vetoesHiding()) {
                    this.myHintsStack.remove(i2);
                    info.hint.hide();
                    continue;
                }
                if ((info.flags & mask) == 0 && (!editorChanged || info.reviveOnEditorChange)) continue;
                info.hint.hide();
                this.myHintsStack.remove(info);
                if ((mask & 1) != 0 && (info.flags & 0x200) != 0) continue;
                if (onlyOne) {
                    boolean bl = true;
                    return bl;
                }
                done2 = true;
            }
            boolean bl = done2;
            return bl;
        }
        finally {
            if (this.myHintsStack.isEmpty()) {
                this.updateLastEditor(null);
            }
        }
    }

    private static EditorHintListener getPublisher() {
        return EditorHintListenerHolder.ourEditorHintPublisher;
    }

    private static class EditorHintListenerHolder {
        private static final EditorHintListener ourEditorHintPublisher = (EditorHintListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorHintListener.TOPIC);

        private EditorHintListenerHolder() {
        }
    }

    private final class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectOpened(Project project2) {
            project2.getMessageBus().connect((Disposable)project2).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)HintManagerImpl.this.myEditorManagerListener);
        }

        public void projectClosed(Project project2) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            TooltipController.getInstance().cancelTooltips();
            ApplicationManager.getApplication().invokeLater(() -> HintManagerImpl.this.hideHints(0, false, false));
            HintManagerImpl.this.myQuestionAction = null;
            HintManagerImpl.this.myQuestionHint = null;
            if (HintManagerImpl.this.myLastEditor != null && project2 == HintManagerImpl.this.myLastEditor.getProject()) {
                HintManagerImpl.this.updateLastEditor(null);
            }
        }
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/hint/HintManagerImpl$MyEditorManagerListener", "selectionChanged"));
            }
            HintManagerImpl.this.hideHints(0, false, true);
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (action instanceof ActionToIgnore) {
                return;
            }
            AnAction escapeAction = ActionManagerEx.getInstanceEx().getAction("EditorEscape");
            if (action == escapeAction) {
                return;
            }
            HintManagerImpl.this.hideHints(2, false, false);
        }
    }

    private static class HintInfo {
        final LightweightHint hint;
        @HintManager.HideFlags
        final int flags;
        private final boolean reviveOnEditorChange;

        private HintInfo(LightweightHint hint, @HintManager.HideFlags int flags, boolean reviveOnEditorChange) {
            this.hint = hint;
            this.flags = flags;
            this.reviveOnEditorChange = reviveOnEditorChange;
        }
    }

    public static interface ActionToIgnore {
    }
}

