/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeannotateIntentionAction
implements IntentionAction,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + DeannotateIntentionAction.class.getName()));
    private String myAnnotationName;

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]) + (this.myAnnotationName != null ? " " + this.myAnnotationName : "...");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        ExternalAnnotationsManager externalAnnotationsManager;
        PsiAnnotation[] annotations;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction", "isAvailable"));
        }
        this.myAnnotationName = null;
        PsiModifierListOwner listOwner = DeannotateIntentionAction.getContainer(editor, file2);
        if (listOwner != null && (annotations = (externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project2)).findExternalAnnotations(listOwner)) != null && annotations.length > 0) {
            List files;
            if (annotations.length == 1) {
                this.myAnnotationName = annotations[0].getQualifiedName();
            }
            if ((files = externalAnnotationsManager.findExternalAnnotationsFiles(listOwner)) == null || files.isEmpty()) {
                return false;
            }
            VirtualFile virtualFile = ((PsiFile)files.get(0)).getVirtualFile();
            return virtualFile != null && (virtualFile.isWritable() || virtualFile.isInLocalFileSystem());
        }
        return false;
    }

    @Nullable
    public static PsiModifierListOwner getContainer(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
        if (listOwner == null) {
            PsiIdentifier psiIdentifier = (PsiIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIdentifier.class, (boolean)false);
            if (psiIdentifier != null && psiIdentifier.getParent() instanceof PsiModifierListOwner) {
                listOwner = (PsiModifierListOwner)psiIdentifier.getParent();
            } else {
                PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
                if (expression != null) {
                    PsiMethod psiMethod;
                    while (expression.getParent() instanceof PsiExpression && !((expression = (PsiExpression)expression.getParent()) instanceof PsiAssignmentExpression)) {
                    }
                    if (expression instanceof PsiMethodCallExpression && (psiMethod = ((PsiMethodCallExpression)expression).resolveMethod()) != null) {
                        return psiMethod;
                    }
                    PsiElement parent = expression.getParent();
                    if (parent instanceof PsiExpressionList) {
                        PsiParameter[] parameters;
                        PsiMethod method2;
                        PsiElement grParent;
                        int idx = -1;
                        PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
                        for (int i2 = 0; i2 < args.length; ++i2) {
                            PsiExpression arg = args[i2];
                            if (!PsiTreeUtil.isAncestor((PsiElement)arg, (PsiElement)expression, (boolean)false)) continue;
                            idx = i2;
                            break;
                        }
                        if (idx > -1 && (grParent = parent.getParent()) instanceof PsiCall && (method2 = ((PsiCall)grParent).resolveMethod()) != null && (parameters = method2.getParameterList().getParameters()).length > idx) {
                            return parameters[idx];
                        }
                    }
                }
            }
        }
        return listOwner;
    }

    public void invoke(final @NotNull Project project2, Editor editor, final PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction", "invoke"));
        }
        final PsiModifierListOwner listOwner = DeannotateIntentionAction.getContainer(editor, file2);
        LOG.assertTrue(listOwner != null);
        final ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project2);
        PsiAnnotation[] externalAnnotations = annotationsManager.findExternalAnnotations(listOwner);
        LOG.assertTrue(externalAnnotations != null && externalAnnotations.length > 0);
        if (externalAnnotations.length == 1) {
            this.deannotate(externalAnnotations[0], project2, file2, annotationsManager, listOwner);
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiAnnotation>(CodeInsightBundle.message((String)"deannotate.intention.chooser.title", (Object[])new Object[0]), externalAnnotations){

            public PopupStep onChosen(PsiAnnotation selectedValue, boolean finalChoice) {
                DeannotateIntentionAction.this.deannotate(selectedValue, project2, file2, annotationsManager, listOwner);
                return PopupStep.FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiAnnotation value) {
                String qualifiedName = value.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                String string = qualifiedName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction$1", "getTextFor"));
                }
                return string;
            }
        }).showInBestPositionFor(editor);
    }

    private void deannotate(final PsiAnnotation annotation, Project project2, final PsiFile file2, final ExternalAnnotationsManager annotationsManager, final PsiModifierListOwner listOwner) {
        new WriteCommandAction(project2, this.getText(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/intention/impl/DeannotateIntentionAction$2", "run"));
                }
                VirtualFile virtualFile = file2.getVirtualFile();
                String qualifiedName = annotation.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                if (annotationsManager.deannotate(listOwner, qualifiedName) && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                    UndoUtil.markPsiFileForUndo((PsiFile)file2);
                }
            }
        }.execute();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

