/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineStreamMapAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)InlineStreamMapAction.class.getName());
    private static final Set<String> MAP_METHODS = StreamEx.of((Object[])new String[]{"map", "mapToInt", "mapToLong", "mapToDouble", "mapToObj", "boxed", "asLongStream", "asDoubleStream"}).toSet();
    private static final Set<String> NEXT_METHODS = StreamEx.of((Object[])new String[]{"flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble", "forEach", "forEachOrdered", "anyMatch", "noneMatch", "allMatch"}).append(MAP_METHODS).toSet();

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "isAvailable"));
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression curCall = (PsiMethodCallExpression)gParent;
        if (!InlineStreamMapAction.isMapCall(curCall)) {
            return false;
        }
        PsiMethodCallExpression nextCall = InlineStreamMapAction.getNextExpressionToMerge(curCall);
        if (nextCall == null) {
            return false;
        }
        String key2 = curCall.getArgumentList().getExpressions().length == 0 || nextCall.getArgumentList().getExpressions().length == 0 ? "intention.inline.map.merge.text" : "intention.inline.map.inline.text";
        this.setText(CodeInsightBundle.message((String)key2, (Object[])new Object[]{element.getText(), nextCall.getMethodExpression().getReferenceName()}));
        return true;
    }

    private static boolean isMapCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "isMapCall"));
        }
        String name = methodCallExpression.getMethodExpression().getReferenceName();
        if (name == null || !MAP_METHODS.contains(name)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions = argumentList.getExpressions();
        if (!name.startsWith("map") && expressions.length == 0) {
            return true;
        }
        if (expressions.length != 1) {
            return false;
        }
        if (!StreamRefactoringUtil.isRefactoringCandidate(expressions[0], true)) {
            return false;
        }
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.stream.BaseStream");
    }

    @Nullable
    private static PsiMethodCallExpression getNextExpressionToMerge(PsiMethodCallExpression methodCallExpression) {
        PsiElement parent = methodCallExpression.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return null;
        }
        String nextName = ((PsiReferenceExpression)parent).getReferenceName();
        PsiMethodCallExpression nextCall = (PsiMethodCallExpression)gParent;
        if (nextName == null || !NEXT_METHODS.contains(nextName) || InlineStreamMapAction.translateName(methodCallExpression, nextCall) == null) {
            return null;
        }
        PsiExpressionList argumentList = nextCall.getArgumentList();
        PsiExpression[] expressions = argumentList.getExpressions();
        if (expressions.length == 0) {
            if (!(nextName.equals("boxed") || nextName.equals("asLongStream") || nextName.equals("asDoubleStream"))) {
                return null;
            }
            return nextCall;
        }
        if (expressions.length != 1 || !StreamRefactoringUtil.isRefactoringCandidate(expressions[0], false)) {
            return null;
        }
        return nextCall;
    }

    @Nullable
    private static String translateName(@NotNull PsiMethodCallExpression prevCall, @NotNull PsiMethodCallExpression nextCall) {
        if (prevCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevCall", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "translateName"));
        }
        if (nextCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nextCall", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "translateName"));
        }
        PsiMethod nextMethod = nextCall.resolveMethod();
        if (nextMethod == null) {
            return null;
        }
        String nextName = nextMethod.getName();
        PsiMethod method2 = prevCall.resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiClass prevClass = method2.getContainingClass();
        if (prevClass == null) {
            return null;
        }
        String prevClassName = prevClass.getQualifiedName();
        if (prevClassName == null) {
            return null;
        }
        String prevName = method2.getName();
        if (nextName.endsWith("Match") || nextName.startsWith("forEach")) {
            return nextName;
        }
        if (nextName.equals("map")) {
            return InlineStreamMapAction.translateMap(prevName);
        }
        if (prevName.equals("map")) {
            return InlineStreamMapAction.translateMap(nextName);
        }
        if (MAP_METHODS.contains(nextName)) {
            PsiType type = nextMethod.getReturnType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClass nextClass = ((PsiClassType)type).resolve();
            if (nextClass == null) {
                return null;
            }
            String nextClassName = nextClass.getQualifiedName();
            if (nextClassName == null) {
                return null;
            }
            if (prevClassName.equals(nextClassName)) {
                return "map";
            }
            switch (nextClassName) {
                case "java.util.stream.IntStream": {
                    return "mapToInt";
                }
                case "java.util.stream.LongStream": {
                    return "mapToLong";
                }
                case "java.util.stream.DoubleStream": {
                    return "mapToDouble";
                }
                case "java.util.stream.Stream": {
                    return "mapToObj";
                }
            }
            return null;
        }
        if (nextName.equals("flatMap") && prevClassName.equals("java.util.stream.Stream")) {
            return InlineStreamMapAction.mapToFlatMap(prevName);
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    private static String mapToFlatMap(String mapMethod) {
        switch (mapMethod) {
            case "map": {
                return "flatMap";
            }
            case "mapToInt": {
                return "flatMapToInt";
            }
            case "mapToLong": {
                return "flatMapToLong";
            }
            case "mapToDouble": {
                return "flatMapToDouble";
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    private static String translateMap(String nextMethod) {
        switch (nextMethod) {
            case "boxed": {
                if ("mapToObj" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "translateMap"));
                }
                return "mapToObj";
            }
            case "asLongStream": {
                if ("mapToLong" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "translateMap"));
                }
                return "mapToLong";
            }
            case "asDoubleStream": {
                if ("mapToDouble" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "translateMap"));
                }
                return "mapToDouble";
            }
        }
        String string = nextMethod;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "translateMap"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.inline.map.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement body;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/InlineStreamMapAction", "invoke"));
        }
        PsiMethodCallExpression mapCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (mapCall == null) {
            return;
        }
        PsiMethodCallExpression nextCall = InlineStreamMapAction.getNextExpressionToMerge(mapCall);
        if (nextCall == null) {
            return;
        }
        PsiReferenceExpression nextRef = nextCall.getMethodExpression();
        PsiExpression nextQualifier = nextRef.getQualifierExpression();
        if (nextQualifier == null) {
            return;
        }
        String newName = InlineStreamMapAction.translateName(mapCall, nextCall);
        if (newName == null) {
            return;
        }
        PsiLambdaExpression previousLambda = InlineStreamMapAction.getLambda(mapCall);
        LOG.assertTrue(previousLambda != null);
        PsiExpression previousBody = LambdaUtil.extractSingleExpressionFromBody((PsiElement)previousLambda.getBody());
        LOG.assertTrue(previousBody != null);
        PsiLambdaExpression lambda2 = InlineStreamMapAction.getLambda(nextCall);
        LOG.assertTrue(lambda2 != null);
        CommentTracker ct = new CommentTracker();
        if (!lambda2.isPhysical()) {
            lambda2 = (PsiLambdaExpression)nextCall.getArgumentList().add((PsiElement)lambda2);
        }
        LOG.assertTrue((body = lambda2.getBody()) != null);
        ct.markUnchanged(body);
        PsiParameter[] nextParameters = lambda2.getParameterList().getParameters();
        LOG.assertTrue(nextParameters.length == 1);
        PsiParameter[] prevParameters = previousLambda.getParameterList().getParameters();
        LOG.assertTrue(prevParameters.length == 1);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)nextParameters[0], (SearchScope)new LocalSearchScope(body)).findAll()) {
            PsiElement e = ref.getElement();
            PsiExpression replacement = ct.markUnchanged(previousBody);
            if (e.getParent() instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(previousBody, (PsiExpression)e.getParent(), false)) {
                replacement = factory.createExpressionFromText("(a)", e);
                PsiExpression parenthesized = ((PsiParenthesizedExpression)replacement).getExpression();
                LOG.assertTrue(parenthesized != null);
                parenthesized.replace((PsiElement)previousBody);
            }
            ct.replace(e, (PsiElement)replacement);
        }
        ct.replace((PsiElement)nextParameters[0], (PsiElement)ct.markUnchanged(prevParameters[0]));
        ExpressionUtils.bindReferenceTo(nextRef, newName);
        PsiExpression prevQualifier = mapCall.getMethodExpression().getQualifierExpression();
        if (prevQualifier == null) {
            ct.deleteAndRestoreComments((PsiElement)nextQualifier);
        } else {
            ct.replaceAndRestoreComments((PsiElement)nextQualifier, (PsiElement)ct.markUnchanged(prevQualifier));
        }
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)lambda2);
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiMethodCallExpression call) {
        String expression;
        String type;
        String varName;
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length == 1) {
            PsiExpression expression2 = expressions[0];
            if (expression2 instanceof PsiLambdaExpression) {
                return (PsiLambdaExpression)expression2;
            }
            if (expression2 instanceof PsiMethodReferenceExpression) {
                return LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)expression2, false, true);
            }
            return null;
        }
        if (expressions.length != 0) {
            return null;
        }
        PsiMethod method2 = call.resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        switch (className) {
            case "java.util.stream.IntStream": {
                varName = "i";
                type = "java.lang.Integer";
                break;
            }
            case "java.util.stream.LongStream": {
                varName = "l";
                type = "java.lang.Long";
                break;
            }
            case "java.util.stream.DoubleStream": {
                varName = "d";
                type = "java.lang.Double";
                break;
            }
            default: {
                return null;
            }
        }
        varName = JavaCodeStyleManager.getInstance((Project)call.getProject()).suggestUniqueVariableName(varName, (PsiElement)call, true);
        if ("boxed".equals(method2.getName())) {
            expression = varName + " -> (" + type + ")" + varName;
        } else if ("asLongStream".equals(method2.getName())) {
            expression = varName + " -> (long)" + varName;
        } else if ("asDoubleStream".equals(method2.getName())) {
            expression = varName + " -> (double)" + varName;
        } else {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)call.getProject());
        return (PsiLambdaExpression)factory.createExpressionFromText(expression, (PsiElement)call);
    }
}

