/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.MergeFilterChainAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SplitFilterAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)SplitFilterAction.class.getName());

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SplitFilterAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SplitFilterAction", "isAvailable"));
        }
        PsiPolyadicExpression expression = SplitConditionUtil.findCondition(element, true, false);
        if (expression == null || expression.getOperands().length < 2) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (!(parent instanceof PsiLambdaExpression)) {
            return false;
        }
        if (((PsiLambdaExpression)parent).getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        return MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent);
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.split.filter.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SplitFilterAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.filter.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SplitFilterAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SplitFilterAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SplitFilterAction", "invoke"));
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiPolyadicExpression expression = SplitConditionUtil.findCondition(element, true, false);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiLambdaExpression.class);
        LOG.assertTrue(lambdaExpression != null);
        String lambdaParameterName = lambdaExpression.getParameterList().getParameters()[0].getName();
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class);
        LOG.assertTrue(methodCallExpression != null, (Object)expression);
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression, token);
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)expression, PsiComment.class);
        PsiMethodCallExpression chainedCall = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("a.filter(" + lambdaParameterName + " -> x)", (PsiElement)expression);
        PsiExpression argExpression = chainedCall.getArgumentList().getExpressions()[0];
        PsiElement rReplaced = ((PsiLambdaExpression)argExpression).getBody().replace((PsiElement)rOperand);
        PsiExpression compoundArg = methodCallExpression.getArgumentList().getExpressions()[0];
        int separatorOffset = token.getTextOffset();
        for (PsiComment comment : comments) {
            if (comment.getTextOffset() < separatorOffset) {
                compoundArg.getParent().add((PsiElement)comment);
                continue;
            }
            rReplaced.getParent().add((PsiElement)comment);
        }
        ((PsiLambdaExpression)compoundArg).getBody().replace((PsiElement)lOperand);
        chainedCall.getMethodExpression().getQualifierExpression().replace((PsiElement)methodCallExpression);
        methodCallExpression.replace((PsiElement)chainedCall);
    }
}

