/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.util.LambdaRefactoringUtil;

public class StreamRefactoringUtil {
    static boolean isRefactoringCandidate(PsiExpression expression, boolean requireExpressionLambda) {
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)expression;
            return lambdaExpression.getParameterList().getParametersCount() == 1 && (!requireExpressionLambda || LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody()) != null);
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            return LambdaRefactoringUtil.canConvertToLambdaWithoutSideEffects((PsiMethodReferenceExpression)expression);
        }
        return false;
    }
}

