/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundAutoCloseableAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "isAvailable"));
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(LanguageLevel.JDK_1_7)) {
            return false;
        }
        PsiType type = null;
        PsiLocalVariable variable = SurroundAutoCloseableAction.findVariable(element);
        if (variable != null) {
            type = variable.getType();
        } else {
            PsiExpression expression = SurroundAutoCloseableAction.findExpression(element);
            if (expression != null) {
                type = expression.getType();
            }
        }
        return type != null && SurroundAutoCloseableAction.rightType(type);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "invoke"));
        }
        PsiLocalVariable variable = SurroundAutoCloseableAction.findVariable(element);
        if (variable != null) {
            SurroundAutoCloseableAction.processVariable(project2, editor, variable);
        } else {
            PsiExpression expression = SurroundAutoCloseableAction.findExpression(element);
            if (expression != null) {
                SurroundAutoCloseableAction.processExpression(project2, editor, expression);
            }
        }
    }

    private static PsiLocalVariable findVariable(PsiElement element) {
        PsiElement lastVar;
        PsiElement sibling;
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (variable != null && variable.getInitializer() != null && variable.getParent() instanceof PsiDeclarationStatement && variable.getParent().getParent() instanceof PsiCodeBlock) {
            return variable;
        }
        if (variable == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiDeclarationStatement && (lastVar = (PsiElement)ArrayUtil.getLastElement((Object[])((PsiDeclarationStatement)sibling).getDeclaredElements())) instanceof PsiLocalVariable) {
            return (PsiLocalVariable)lastVar;
        }
        return null;
    }

    private static PsiExpression findExpression(PsiElement element) {
        PsiElement sibling;
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        if (expression != null && expression.getParent() instanceof PsiExpressionStatement && expression.getParent().getParent() instanceof PsiCodeBlock) {
            return expression;
        }
        if (expression == null && element instanceof PsiWhiteSpace && (sibling = element.getPrevSibling()) instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)sibling).getExpression();
        }
        return null;
    }

    private static boolean rightType(PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.AutoCloseable");
    }

    private static void processVariable(Project project2, Editor editor, PsiLocalVariable variable) {
        PsiJavaToken brace;
        PsiCodeBlock tryBlock;
        PsiExpression initializer = (PsiExpression)ObjectUtils.assertNotNull((Object)variable.getInitializer());
        PsiElement declaration = variable.getParent();
        PsiElement codeBlock = declaration.getParent();
        LocalSearchScope scope = new LocalSearchScope(codeBlock);
        PsiElement last = null;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll()) {
            PsiElement usage = PsiTreeUtil.findPrevParent((PsiElement)codeBlock, (PsiElement)reference.getElement());
            if (last != null && usage.getTextOffset() <= last.getTextOffset()) continue;
            last = usage;
        }
        String text = "try (" + variable.getTypeElement().getText() + " " + variable.getName() + " = " + initializer.getText() + ") {}";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiTryStatement armStatement = (PsiTryStatement)declaration.replace((PsiElement)factory.createStatementFromText(text, codeBlock));
        List<PsiElement> toFormat = null;
        if (last != null) {
            toFormat = SurroundAutoCloseableAction.moveStatements(last, armStatement);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiElement formattedElement = codeStyleManager.reformat((PsiElement)armStatement);
        if (toFormat != null) {
            for (PsiElement psiElement : toFormat) {
                codeStyleManager.reformat(psiElement);
            }
        }
        if (last == null && (tryBlock = ((PsiTryStatement)formattedElement).getTryBlock()) != null && (brace = tryBlock.getLBrace()) != null) {
            editor.getCaretModel().moveToOffset(brace.getTextOffset() + 1);
        }
    }

    private static List<PsiElement> moveStatements(PsiElement last, PsiTryStatement statement2) {
        PsiCodeBlock tryBlock = statement2.getTryBlock();
        assert (tryBlock != null) : statement2.getText();
        PsiElement parent = statement2.getParent();
        LocalSearchScope scope = new LocalSearchScope(parent);
        SmartList toFormat = new SmartList();
        PsiElement stopAt = last.getNextSibling();
        PsiElement i2 = statement2.getNextSibling();
        while (i2 != null && i2 != stopAt) {
            PsiElement child = i2;
            i2 = PsiTreeUtil.skipSiblingsForward((PsiElement)i2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            if (!(child instanceof PsiDeclarationStatement)) continue;
            PsiElement anchor = child;
            for (PsiElement declared : ((PsiDeclarationStatement)child).getDeclaredElements()) {
                if (!(declared instanceof PsiLocalVariable)) continue;
                int endOffset = last.getTextRange().getEndOffset();
                boolean contained = ReferencesSearch.search((PsiElement)declared, (SearchScope)scope).forEach(ref -> ref.getElement().getTextOffset() <= endOffset);
                if (contained) continue;
                PsiLocalVariable var = (PsiLocalVariable)declared;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement2.getProject());
                String name = var.getName();
                assert (name != null) : child.getText();
                toFormat.add(parent.addBefore((PsiElement)factory.createVariableDeclarationStatement(name, var.getType(), null), (PsiElement)statement2));
                PsiExpression varInit = var.getInitializer();
                if (varInit != null) {
                    String varAssignText = name + " = " + varInit.getText() + ";";
                    anchor = parent.addAfter((PsiElement)factory.createStatementFromText(varAssignText, parent), anchor);
                }
                var.delete();
            }
            if (child != last || child.isValid()) continue;
            last = anchor;
        }
        PsiElement first = statement2.getNextSibling();
        tryBlock.addRangeBefore(first, last, (PsiElement)tryBlock.getRBrace());
        parent.deleteChildRange(first, last);
        return toFormat;
    }

    private static void processExpression(Project project2, Editor editor, PsiExpression expression) {
        PsiType type = (PsiType)ObjectUtils.assertNotNull((Object)expression.getType());
        PsiElement statement2 = expression.getParent();
        PsiElement codeBlock = statement2.getParent();
        String text = "try (" + type.getCanonicalText(true) + " r = " + expression.getText() + ") {}";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiTryStatement tryStatement = (PsiTryStatement)statement2.replace((PsiElement)factory.createStatementFromText(text, codeBlock));
        tryStatement = (PsiTryStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)tryStatement);
        PsiResourceList resourceList = (tryStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(tryStatement)).getResourceList();
        if (resourceList != null) {
            PsiResourceVariable var = (PsiResourceVariable)resourceList.iterator().next();
            PsiIdentifier id = var.getNameIdentifier();
            PsiExpression initializer = var.getInitializer();
            if (id != null && initializer != null) {
                type = initializer.getType();
                String[] names = IntroduceVariableBase.getSuggestedName((PsiType)type, (PsiExpression)initializer).names;
                PsiType[] types = (PsiType[])Stream.of(new TypeSelectorManagerImpl(project2, type, initializer, PsiExpression.EMPTY_ARRAY).getTypesForAll()).filter(SurroundAutoCloseableAction::rightType).toArray(PsiType[]::new);
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)var);
                builder.replaceElement((PsiElement)id, (Expression)new NamesExpression(names));
                builder.replaceElement((PsiElement)var.getTypeElement(), (Expression)new TypeExpression(project2, types));
                builder.run(editor, true);
            }
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.surround.resource.with.ARM.block", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction", "getText"));
        }
        return string;
    }

    public static class Template
    implements SurroundDescriptor,
    Surrounder {
        private Surrounder[] mySurrounders = new Surrounder[]{this};

        @NotNull
        public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
            PsiElement[] psiElementArray;
            PsiExpression expr = CodeInsightUtil.findExpressionInRange(file2, startOffset, endOffset);
            if (expr == null) {
                expr = SurroundAutoCloseableAction.findExpression(file2.findElementAt(endOffset));
            }
            if (expr != null && SurroundAutoCloseableAction.rightType(expr.getType())) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = expr;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template", "getElementsToSurround"));
            }
            return psiElementArray;
        }

        @NotNull
        public Surrounder[] getSurrounders() {
            if (this.mySurrounders == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template", "getSurrounders"));
            }
            return this.mySurrounders;
        }

        public boolean isExclusive() {
            return false;
        }

        public String getTemplateDescription() {
            return CodeInsightBundle.message((String)"intention.surround.with.ARM.block.template", (Object[])new Object[0]);
        }

        public boolean isApplicable(@NotNull PsiElement[] elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template", "isApplicable"));
            }
            return true;
        }

        @Nullable
        public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement[] elements) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template", "surroundElements"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template", "surroundElements"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/intention/impl/SurroundAutoCloseableAction$Template", "surroundElements"));
            }
            if (elements.length == 1 && elements[0] instanceof PsiExpression) {
                SurroundAutoCloseableAction.processExpression(project2, editor, (PsiExpression)elements[0]);
            }
            return null;
        }
    }

    private static class NamesExpression
    extends Expression {
        private final String[] myNames;

        public NamesExpression(String[] names) {
            this.myNames = names;
        }

        public Result calculateResult(ExpressionContext context) {
            return this.calculateQuickResult(context);
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return new TextResult(this.myNames[0]);
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return (LookupElement[])Stream.of(this.myNames).map(LookupElementBuilder::create).toArray(LookupElement[]::new);
        }
    }
}

