/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.InvertIfConditionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnwrapElseBranchAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(UnwrapElseBranchAction.class);

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/UnwrapElseBranchAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/UnwrapElseBranchAction", "invoke"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiElement grandParent = ifStatement.getParent();
            if (elseBranch != null && grandParent != null) {
                if (!(grandParent instanceof PsiCodeBlock)) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
                    PsiCodeBlock codeBlock = factory.createCodeBlockFromText("{" + ifStatement.getText() + "}", (PsiElement)ifStatement);
                    elseBranch = (ifStatement = (PsiIfStatement)(codeBlock = (PsiCodeBlock)ifStatement.replace((PsiElement)codeBlock)).getStatements()[0]).getElseBranch();
                    LOG.assertTrue(elseBranch != null);
                }
                InvertIfConditionAction.addAfter(ifStatement, elseBranch);
                elseBranch.delete();
            }
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiIfStatement ifStatement;
        PsiStatement elseBranch;
        PsiElement parent;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/UnwrapElseBranchAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/UnwrapElseBranchAction", "isAvailable"));
        }
        if (element instanceof PsiKeyword && ((PsiKeyword)element).getTokenType() == JavaTokenType.ELSE_KEYWORD && (parent = element.getParent()) instanceof PsiIfStatement && (elseBranch = (ifStatement = (PsiIfStatement)parent).getElseBranch()) != null) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            boolean thenCompletesNormally = ControlFlowUtils.statementMayCompleteNormally(thenBranch);
            boolean elseCompletesNormally = ControlFlowUtils.statementMayCompleteNormally(elseBranch);
            if (!thenCompletesNormally || elseCompletesNormally || !UnwrapElseBranchAction.nextStatementMayBecomeUnreachable((PsiStatement)ifStatement)) {
                if (thenCompletesNormally) {
                    this.setText(CodeInsightBundle.message((String)"intention.unwrap.else.branch.changes.semantics", (Object[])new Object[0]));
                } else {
                    this.setText(CodeInsightBundle.message((String)"intention.unwrap.else.branch", (Object[])new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    private static boolean nextStatementMayBecomeUnreachable(PsiStatement statement2) {
        PsiStatement parentStatement;
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
        if (nextStatement != null) {
            return !(nextStatement instanceof PsiSwitchLabelStatement);
        }
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (thenBranch == statement2 && ControlFlowUtils.statementMayCompleteNormally(elseBranch) || elseBranch == statement2 && ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return false;
            }
            return UnwrapElseBranchAction.nextStatementMayBecomeUnreachable((PsiStatement)ifStatement);
        }
        if (parent instanceof PsiLabeledStatement) {
            return UnwrapElseBranchAction.nextStatementMayBecomeUnreachable((PsiStatement)((PsiLabeledStatement)parent));
        }
        if (parent instanceof PsiCodeBlock && ((parentStatement = (PsiStatement)ObjectUtils.tryCast((Object)parent.getParent(), PsiStatement.class)) instanceof PsiBlockStatement || parentStatement instanceof PsiSynchronizedStatement || parentStatement instanceof PsiTryStatement || parentStatement instanceof PsiSwitchStatement)) {
            return UnwrapElseBranchAction.nextStatementMayBecomeUnreachable(parentStatement);
        }
        return false;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.unwrap.else.branch", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/UnwrapElseBranchAction", "getFamilyName"));
        }
        return string;
    }
}

