/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.documentation.AbstractExternalFilter;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;

public class JavaDocExternalFilter
extends AbstractExternalFilter {
    private final Project myProject;
    private PsiElement myElement;
    private static final AbstractExternalFilter.ParseSettings ourPackageInfoSettings = new AbstractExternalFilter.ParseSettings(Pattern.compile("package\\s+[^\\s]+\\s+description", 2), Pattern.compile("START OF BOTTOM NAVBAR", 2), true, false);
    @NonNls
    protected static final Pattern ourAnchorsuffix = Pattern.compile("#(.*)$");
    @NonNls
    protected static final Pattern ourHTMLFilesuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    @NonNls
    private static final Pattern ourHREFselector = Pattern.compile("<A.*?HREF=\"([^>\"]*)\"", 34);
    @NonNls
    private static final Pattern ourMethodHeading = Pattern.compile("<H[34]>(.+?)</H[34]>", 34);
    @NonNls
    protected static final String H2 = "</H2>";
    @NonNls
    protected static final String HTML_CLOSE = "</HTML>";
    @NonNls
    protected static final String HTML = "<HTML>";
    private final AbstractExternalFilter.RefConvertor[] myReferenceConvertors = new AbstractExternalFilter.RefConvertor[]{new AbstractExternalFilter.RefConvertor(ourHREFselector){

        @Override
        protected String convertReference(String root, String href) {
            if (BrowserUtil.isAbsoluteURL((String)href)) {
                return href;
            }
            String reference = JavaDocInfoGenerator.createReferenceForRelativeLink(href, JavaDocExternalFilter.this.myElement);
            if (reference == null) {
                if (href.startsWith("#")) {
                    return root + href;
                }
                String nakedRoot = ourHTMLFilesuffix.matcher(root).replaceAll("/");
                return JavaDocExternalFilter.doAnnihilate(nakedRoot + href);
            }
            return reference;
        }
    }};

    public JavaDocExternalFilter(Project project2) {
        this.myProject = project2;
    }

    @Override
    protected AbstractExternalFilter.RefConvertor[] getRefConverters() {
        return this.myReferenceConvertors;
    }

    @Nullable
    public static String filterInternalDocInfo(String text) {
        if (text == null) {
            return null;
        }
        text = PlatformDocumentationUtil.fixupText(text);
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getExternalDocInfoForElement(@NotNull String docURL, final PsiElement element) throws Exception {
        if (docURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docURL", "com/intellij/codeInsight/javadoc/JavaDocExternalFilter", "getExternalDocInfoForElement"));
        }
        String externalDoc = null;
        this.myElement = element;
        String projectPath = "/" + this.myProject.getName() + "/";
        String builtInServer = "http://localhost:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() + projectPath;
        if (docURL.startsWith(builtInServer)) {
            VirtualFile file2;
            Url url = Urls.parseFromIdea(docURL);
            VirtualFile virtualFile = file2 = url == null ? null : WebServerPathToFileManager.getInstance(this.myProject).findVirtualFile(url.getPath().substring(projectPath.length()));
            if (file2 != null) {
                StringBuilder result2 = new StringBuilder();
                try (InputStreamReader reader = new InputStreamReader(file2.getInputStream(), StandardCharsets.UTF_8);){
                    this.doBuildFromStream(docURL, reader, result2);
                }
                externalDoc = this.correctDocText(docURL, result2);
            }
        }
        if (externalDoc == null) {
            externalDoc = super.getExternalDocInfoForElement(docURL, element);
        }
        if (externalDoc == null) {
            return null;
        }
        if (element instanceof PsiMethod) {
            String className = (String)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<String>(){

                @Nullable
                public String compute() {
                    PsiClass aClass = ((PsiMethod)element).getContainingClass();
                    return aClass == null ? null : aClass.getQualifiedName();
                }
            });
            Matcher matcher = ourMethodHeading.matcher(externalDoc);
            StringBuilder buffer = new StringBuilder("<h3>");
            DocumentationManager.createHyperlink(buffer, className, className, false);
            return matcher.replaceFirst(buffer.append("</h3>").toString());
        }
        return externalDoc;
    }

    @Override
    @NotNull
    protected AbstractExternalFilter.ParseSettings getParseSettings(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/codeInsight/javadoc/JavaDocExternalFilter", "getParseSettings"));
        }
        AbstractExternalFilter.ParseSettings parseSettings = url.endsWith("package-summary.html") ? ourPackageInfoSettings : super.getParseSettings(url);
        if (parseSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/javadoc/JavaDocExternalFilter", "getParseSettings"));
        }
        return parseSettings;
    }
}

