/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupArranger
implements WeighingContext {
    protected final List<LookupElement> myItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myMatchingItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myExactPrefixItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myInexactPrefixItems = new ArrayList<LookupElement>();
    private final Map<LookupElement, PrefixMatcher> myMatchers = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private String myAdditionalPrefix = "";

    public void addElement(LookupElement item, LookupElementPresentation presentation) {
        this.myItems.add(item);
        this.updateCache(item);
    }

    private void updateCache(LookupElement item) {
        if (!this.prefixMatches(item)) {
            return;
        }
        this.myMatchingItems.add(item);
        if (this.isPrefixItem(item, true)) {
            this.myExactPrefixItems.add(item);
        } else if (this.isPrefixItem(item, false)) {
            this.myInexactPrefixItems.add(item);
        }
    }

    public void registerMatcher(@NotNull LookupElement item, @NotNull PrefixMatcher matcher) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/lookup/LookupArranger", "registerMatcher"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/lookup/LookupArranger", "registerMatcher"));
        }
        this.myMatchers.put(item, matcher);
    }

    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/lookup/LookupArranger", "itemPattern"));
        }
        String prefix = this.itemMatcher(element).getPrefix();
        String additionalPrefix = this.myAdditionalPrefix;
        String string = additionalPrefix.isEmpty() ? prefix : prefix + additionalPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupArranger", "itemPattern"));
        }
        return string;
    }

    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/lookup/LookupArranger", "itemMatcher"));
        }
        PrefixMatcher matcher = this.myMatchers.get(item);
        if (matcher == null) {
            throw new AssertionError((Object)("Item not in lookup: item=" + item + "; lookup items=" + this.myItems));
        }
        PrefixMatcher prefixMatcher = matcher;
        if (prefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupArranger", "itemMatcher"));
        }
        return prefixMatcher;
    }

    private boolean prefixMatches(LookupElement item) {
        PrefixMatcher matcher = this.itemMatcher(item);
        if (!this.myAdditionalPrefix.isEmpty()) {
            matcher = matcher.cloneWithPrefix(matcher.getPrefix() + this.myAdditionalPrefix);
        }
        return matcher.prefixMatches(item);
    }

    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
    }

    public final void prefixReplaced(Lookup lookup, String newPrefix) {
        LinkedHashMap newMatchers = new LinkedHashMap(EqualityPolicy.IDENTITY);
        for (LookupElement item : this.myItems) {
            PrefixMatcher matcher;
            if (!item.isValid() || !(matcher = this.itemMatcher(item).cloneWithPrefix(newPrefix)).prefixMatches(item)) continue;
            newMatchers.put(item, matcher);
        }
        this.myMatchers.clear();
        this.myMatchers.putAll((Map<LookupElement, PrefixMatcher>)newMatchers);
        this.myItems.clear();
        this.myItems.addAll(newMatchers.keySet());
        this.prefixChanged(lookup);
    }

    public void prefixChanged(Lookup lookup) {
        this.myAdditionalPrefix = ((LookupImpl)lookup).getAdditionalPrefix();
        this.rebuildItemCache();
    }

    private void rebuildItemCache() {
        this.myMatchingItems.clear();
        this.myExactPrefixItems.clear();
        this.myInexactPrefixItems.clear();
        for (LookupElement item : this.myItems) {
            this.updateCache(item);
        }
    }

    protected List<LookupElement> retainItems(Set<LookupElement> retained) {
        ArrayList filtered = ContainerUtil.newArrayList();
        ArrayList removed = ContainerUtil.newArrayList();
        for (LookupElement item : this.myItems) {
            (retained.contains(item) ? filtered : removed).add(item);
        }
        this.myItems.clear();
        this.myItems.addAll(filtered);
        this.rebuildItemCache();
        return removed;
    }

    public abstract Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup var1, boolean var2);

    public abstract LookupArranger createEmptyCopy();

    protected List<LookupElement> getPrefixItems(boolean exactly) {
        return Collections.unmodifiableList(exactly ? this.myExactPrefixItems : this.myInexactPrefixItems);
    }

    protected boolean isPrefixItem(LookupElement item, boolean exactly) {
        String pattern = this.itemPattern(item);
        for (String s : item.getAllLookupStrings()) {
            if (!s.equalsIgnoreCase(pattern) || item.isCaseSensitive() && exactly && !s.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    protected List<LookupElement> getMatchingItems() {
        return this.myMatchingItems;
    }

    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/lookup/LookupArranger", "getRelevanceObjects"));
        }
        Map<LookupElement, List<Pair<String, Object>>> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupArranger", "getRelevanceObjects"));
        }
        return map;
    }

    public static class DefaultArranger
    extends LookupArranger {
        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/LookupArranger$DefaultArranger", "arrangeItems"));
            }
            LinkedHashSet<LookupElement> result2 = new LinkedHashSet<LookupElement>();
            result2.addAll(this.getPrefixItems(true));
            result2.addAll(this.getPrefixItems(false));
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!CompletionServiceImpl.isStartMatch(item, this)) continue;
                result2.add(item);
            }
            result2.addAll(items);
            ArrayList list = new ArrayList(result2);
            int selected = !lookup.isSelectionTouched() && onExplicitAction ? 0 : list.indexOf(lookup.getCurrentItem());
            return new Pair(list, (Object)(selected >= 0 ? selected : 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new DefaultArranger();
        }
    }
}

