/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.List;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Advertiser {
    private final List<Pair<String, Color>> myTexts = ContainerUtil.createLockFreeCopyOnWriteList();
    private volatile Dimension myCachedPrefSize;
    private final JPanel myComponent = new JPanel(new GridBagLayout()){
        private final JLabel mySample;
        {
            this.mySample = Advertiser.createLabel();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = Advertiser.this.myCachedPrefSize;
            if (dimension == null) {
                dimension = this.calcPreferredSize();
                Advertiser.this.myCachedPrefSize = dimension;
            }
            return dimension;
        }

        private Dimension calcPreferredSize() {
            if (Advertiser.this.myTexts.isEmpty()) {
                return new Dimension(-1, 0);
            }
            int maxSize = 0;
            for (Pair label : Advertiser.this.myTexts) {
                this.mySample.setText(Advertiser.prepareText((String)label.first));
                maxSize = Math.max(maxSize, this.mySample.getPreferredSize().width);
            }
            Dimension sup = super.getPreferredSize();
            return new Dimension(maxSize + sup.width - ((Advertiser)Advertiser.this).myTextPanel.getPreferredSize().width, sup.height);
        }
    };
    private volatile int myCurrentItem = 0;
    private final JLabel myTextPanel = Advertiser.createLabel();
    private final JLabel myNextLabel = new JLabel(">>");

    public Advertiser() {
        this.myNextLabel.setFont(Advertiser.adFont().deriveFont(ContainerUtil.immutableMapBuilder().put((Object)TextAttribute.UNDERLINE, (Object)TextAttribute.UNDERLINE_ON).build()));
        this.myNextLabel.setForeground((Color)JBColor.blue);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/Advertiser$2", "onClick"));
                }
                Advertiser.this.myCurrentItem++;
                Advertiser.this.updateAdvertisements();
                return true;
            }
        }.installOn((Component)this.myNextLabel);
        this.myNextLabel.setCursor(Cursor.getPredefinedCursor(12));
        GridBag gb = new GridBag();
        this.myComponent.add((Component)this.myTextPanel, gb.next());
        this.myComponent.add((Component)this.myNextLabel, gb.next());
        this.myComponent.add((Component)new NonOpaquePanel(), gb.next().fillCellHorizontally().weightx(1.0));
    }

    private void updateAdvertisements() {
        this.myNextLabel.setVisible(this.myTexts.size() > 1);
        if (!this.myTexts.isEmpty()) {
            Pair<String, Color> pair = this.myTexts.get(this.myCurrentItem % this.myTexts.size());
            String text = (String)pair.first;
            this.myTextPanel.setText(Advertiser.prepareText(text));
            this.myComponent.setBackground((Color)pair.second);
        } else {
            this.myTextPanel.setText("");
            this.myComponent.setBackground(null);
        }
        this.myCachedPrefSize = null;
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    private static JLabel createLabel() {
        JLabel label = new JLabel();
        label.setFont(Advertiser.adFont());
        return label;
    }

    private static String prepareText(String text) {
        return text + "  ";
    }

    public void showRandomText() {
        int count = this.myTexts.size();
        this.myCurrentItem = count > 0 ? new Random().nextInt(count) : 0;
        this.updateAdvertisements();
    }

    public void clearAdvertisements() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTexts.clear();
        this.myCurrentItem = 0;
        this.updateAdvertisements();
    }

    private static Font adFont() {
        Font font = UIUtil.getLabelFont();
        return font.deriveFont((float)(font.getSize() - 2));
    }

    public void addAdvertisement(@NotNull String text, @Nullable Color bgColor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/lookup/impl/Advertiser", "addAdvertisement"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTexts.add((Pair<String, Color>)Pair.create((Object)text, (Object)bgColor));
        this.updateAdvertisements();
    }

    public JComponent getAdComponent() {
        return this.myComponent;
    }

    public List<String> getAdvertisements() {
        return ContainerUtil.map(this.myTexts, pair -> (String)pair.first);
    }
}

