/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TrimZenCodingFilter
extends ZenCodingFilter {
    private static final Pattern PATTERN = Pattern.compile("^([\\s|\u00a0])?[\\d|#|\\-|\\*|\u2022]+\\.?\\s*");

    @Override
    @NotNull
    public String getSuffix() {
        if ("t" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "getSuffix"));
        }
        return "t";
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "isMyContext"));
        }
        return context.getLanguage() instanceof XMLLanguage;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Trim line markers" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "getDisplayName"));
        }
        return "Trim line markers";
    }

    @Override
    @NotNull
    public String filterText(@NotNull String text, @NotNull TemplateToken token) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "filterText"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "filterText"));
        }
        XmlDocument document = token.getFile().getDocument();
        if (document != null) {
            XmlTag tag = document.getRootTag();
            if (tag != null && !tag.getText().isEmpty()) {
                tag.accept((PsiElementVisitor)new XmlElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        if (!tag.isEmpty()) {
                            XmlTagValue tagValue = tag.getValue();
                            Matcher matcher = PATTERN.matcher(tagValue.getText());
                            if (matcher.matches()) {
                                ApplicationManager.getApplication().runWriteAction(() -> tagValue.setText(matcher.replaceAll("")));
                            }
                        }
                        tag.acceptChildren((PsiElementVisitor)this);
                    }
                });
                String string = tag.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "filterText"));
                }
                return string;
            }
            String string = PATTERN.matcher(document.getText()).replaceAll("");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "filterText"));
            }
            return string;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "filterText"));
        }
        return string;
    }

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "filterNode"));
        }
        TrimZenCodingFilter.doFilter(node);
        GenerationNode generationNode = node;
        if (generationNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/TrimZenCodingFilter", "filterNode"));
        }
        return generationNode;
    }

    private static void doFilter(GenerationNode node) {
        String surroundedText = node.getSurroundedText();
        if (surroundedText != null) {
            node.setSurroundedText(PATTERN.matcher(surroundedText).replaceAll(""));
        }
        for (GenerationNode child : node.getChildren()) {
            TrimZenCodingFilter.doFilter(child);
        }
    }
}

