/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListTemplatesHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(ListTemplatesHandler.class);

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "invoke"));
        }
        EditorUtil.fillVirtualSpaceUntilCaret(editor);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        int offset = editor.getCaretModel().getOffset();
        List<TemplateImpl> applicableTemplates = TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(editor, file2, false);
        Map<TemplateImpl, String> matchingTemplates = ListTemplatesHandler.filterTemplatesByPrefix(applicableTemplates, editor, offset, false, true);
        MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements = ListTemplatesHandler.getCustomTemplatesLookupItems(editor, file2, offset);
        if (matchingTemplates.isEmpty()) {
            for (TemplateImpl template : applicableTemplates) {
                matchingTemplates.put(template, null);
            }
        }
        if (matchingTemplates.isEmpty() && customTemplatesLookupElements.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"templates.no.defined", (Object[])new Object[0]));
            }
            return;
        }
        ListTemplatesHandler.showTemplatesLookup(project2, editor, file2, matchingTemplates, customTemplatesLookupElements);
    }

    public static Map<TemplateImpl, String> filterTemplatesByPrefix(@NotNull Collection<TemplateImpl> templates, @NotNull Editor editor, int offset, boolean fullMatch, boolean searchInDescription) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "filterTemplatesByPrefix"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "filterTemplatesByPrefix"));
        }
        if (offset > editor.getDocument().getTextLength()) {
            LOG.error("Cannot filter templates, index out of bounds. Offset: " + offset, new Attachment[]{AttachmentFactory.createAttachment(editor.getDocument())});
        }
        CharSequence documentText = editor.getDocument().getCharsSequence().subSequence(0, offset);
        String prefixWithoutDots = ListTemplatesHandler.computeDescriptionMatchingPrefix(editor.getDocument(), offset);
        Pattern prefixSearchPattern = Pattern.compile(".*\\b" + prefixWithoutDots + ".*");
        TreeMap<TemplateImpl, String> matchingTemplates = new TreeMap<TemplateImpl, String>(TemplateListPanel.TEMPLATE_COMPARATOR);
        for (TemplateImpl template : templates) {
            block6: {
                String templateKey;
                block5: {
                    templateKey = template.getKey();
                    if (!fullMatch) break block5;
                    int startOffset = documentText.length() - templateKey.length();
                    if (startOffset > 0 && Character.isJavaIdentifierPart(documentText.charAt(startOffset - 1)) || !StringUtil.endsWith((CharSequence)documentText, (CharSequence)templateKey)) break block6;
                    matchingTemplates.put(template, templateKey);
                    break block6;
                }
                for (int i2 = templateKey.length(); i2 > 0; --i2) {
                    String prefix = templateKey.substring(0, i2);
                    int startOffset = documentText.length() - i2;
                    if (startOffset > 0 && Character.isJavaIdentifierPart(documentText.charAt(startOffset - 1)) || !StringUtil.endsWith((CharSequence)documentText, (CharSequence)prefix)) continue;
                    matchingTemplates.put(template, prefix);
                    break;
                }
            }
            if (!searchInDescription || matchingTemplates.containsKey(template)) continue;
            String templateDescription = template.getDescription();
            if (prefixWithoutDots.isEmpty() || templateDescription == null || !prefixSearchPattern.matcher(templateDescription).matches()) continue;
            matchingTemplates.put(template, prefixWithoutDots);
        }
        return matchingTemplates;
    }

    private static void showTemplatesLookup(Project project2, Editor editor, PsiFile file2, @NotNull Map<TemplateImpl, String> matchingTemplates, @NotNull MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements) {
        if (matchingTemplates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingTemplates", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "showTemplatesLookup"));
        }
        if (customTemplatesLookupElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customTemplatesLookupElements", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "showTemplatesLookup"));
        }
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project2).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new TemplatesArranger());
        for (Map.Entry<TemplateImpl, String> entry : matchingTemplates.entrySet()) {
            TemplateImpl template = entry.getKey();
            lookup.addItem(ListTemplatesHandler.createTemplateElement(template), (PrefixMatcher)new PlainPrefixMatcher(StringUtil.notNullize((String)entry.getValue())));
        }
        for (Map.Entry<TemplateImpl, String> entry : customTemplatesLookupElements.entrySet()) {
            for (CustomLiveTemplateLookupElement lookupElement : (Collection)((Object)entry.getValue())) {
                lookup.addItem(lookupElement, (PrefixMatcher)new PlainPrefixMatcher((String)((Object)entry.getKey())));
            }
        }
        ListTemplatesHandler.showLookup(lookup, file2);
    }

    public static MultiMap<String, CustomLiveTemplateLookupElement> getCustomTemplatesLookupItems(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "getCustomTemplatesLookupItems"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "getCustomTemplatesLookupItems"));
        }
        MultiMap result2 = MultiMap.create();
        CustomTemplateCallback customTemplateCallback = new CustomTemplateCallback(editor, file2);
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(editor, file2, false)) {
            String customTemplatePrefix;
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || (customTemplatePrefix = ((CustomLiveTemplateBase)customLiveTemplate).computeTemplateKeyWithoutContextChecking(customTemplateCallback)) == null) continue;
            result2.putValues((Object)customTemplatePrefix, ((CustomLiveTemplateBase)customLiveTemplate).getLookupElements(file2, editor, offset));
        }
        return result2;
    }

    private static LiveTemplateLookupElement createTemplateElement(final TemplateImpl template) {
        return new LiveTemplateLookupElementImpl(template, false){

            public Set<String> getAllLookupStrings() {
                String description = template.getDescription();
                if (description == null) {
                    return super.getAllLookupStrings();
                }
                return ContainerUtil.newHashSet((Object[])new String[]{this.getLookupString(), description});
            }
        };
    }

    private static String computePrefix(TemplateImpl template, String argument) {
        String key2 = template.getKey();
        if (argument == null) {
            return key2;
        }
        if (key2.length() > 0 && Character.isJavaIdentifierPart(key2.charAt(key2.length() - 1))) {
            return key2 + ' ' + argument;
        }
        return key2 + argument;
    }

    public static void showTemplatesLookup(Project project2, Editor editor, Map<TemplateImpl, String> template2Argument) {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project2).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        for (TemplateImpl template : template2Argument.keySet()) {
            String prefix = ListTemplatesHandler.computePrefix(template, template2Argument.get(template));
            lookup.addItem(ListTemplatesHandler.createTemplateElement(template), (PrefixMatcher)new PlainPrefixMatcher(prefix));
        }
        ListTemplatesHandler.showLookup(lookup, template2Argument);
    }

    private static void showLookup(LookupImpl lookup, @Nullable Map<TemplateImpl, String> template2Argument) {
        lookup.addLookupListener(new MyLookupAdapter(template2Argument));
        lookup.refreshUi(false, true);
        lookup.showLookup();
    }

    private static void showLookup(LookupImpl lookup, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/impl/ListTemplatesHandler", "showLookup"));
        }
        lookup.addLookupListener(new MyLookupAdapter(file2));
        lookup.refreshUi(false, true);
        lookup.showLookup();
    }

    private static String computeDescriptionMatchingPrefix(Document document, int offset) {
        char c;
        int start;
        CharSequence chars = document.getCharsSequence();
        for (start = offset; start != 0 && Character.isJavaIdentifierPart(c = chars.charAt(start - 1)); --start) {
        }
        return chars.subSequence(start, offset).toString();
    }

    private static class TemplatesArranger
    extends LookupArranger {
        private TemplatesArranger() {
        }

        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$TemplatesArranger", "arrangeItems"));
            }
            LinkedHashSet<LookupElement> result2 = new LinkedHashSet<LookupElement>();
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!item.getLookupString().startsWith(lookup.itemPattern(item))) continue;
                result2.add(item);
            }
            result2.addAll(items);
            ArrayList list = new ArrayList(result2);
            int selected = lookup.isSelectionTouched() ? list.indexOf(lookup.getCurrentItem()) : 0;
            return new Pair(list, (Object)(selected >= 0 ? selected : 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new TemplatesArranger();
        }
    }

    private static class MyLookupAdapter
    extends LookupAdapter {
        private final Map<TemplateImpl, String> myTemplate2Argument;
        private final PsiFile myFile;

        public MyLookupAdapter(@Nullable Map<TemplateImpl, String> template2Argument) {
            this.myTemplate2Argument = template2Argument;
            this.myFile = null;
        }

        public MyLookupAdapter(@Nullable PsiFile file2) {
            this.myTemplate2Argument = null;
            this.myFile = file2;
        }

        @Override
        public void itemSelected(LookupEvent event) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.liveTemplates");
            final LookupElement item = event.getItem();
            final Lookup lookup = event.getLookup();
            final Project project2 = lookup.getProject();
            if (item instanceof LiveTemplateLookupElementImpl) {
                final TemplateImpl template = ((LiveTemplateLookupElementImpl)item).getTemplate();
                final String argument = this.myTemplate2Argument != null ? this.myTemplate2Argument.get(template) : null;
                new WriteCommandAction(project2, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$MyLookupAdapter$1", "run"));
                        }
                        ((TemplateManagerImpl)TemplateManager.getInstance(project2)).startTemplateWithPrefix(lookup.getEditor(), template, null, argument);
                    }
                }.execute();
            } else if (item instanceof CustomLiveTemplateLookupElement && this.myFile != null) {
                new WriteCommandAction(project2, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$MyLookupAdapter$2", "run"));
                        }
                        ((CustomLiveTemplateLookupElement)item).expandTemplate(lookup.getEditor(), myFile);
                    }
                }.execute();
            }
        }
    }
}

