/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class IterableComponentTypeMacro
extends Macro {
    public String getName() {
        return "iterableComponentType";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.iterable.component.type", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/IterableComponentTypeMacro", "getDefaultValue"));
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/IterableComponentTypeMacro", "calculateResult"));
        }
        if (params.length != 1) {
            return null;
        }
        Result result2 = params[0].calculateResult(context);
        if (result2 == null) {
            return null;
        }
        Project project2 = context.getProject();
        PsiExpression expr = MacroUtil.resultToPsiExpression(result2, context);
        if (expr == null) {
            return null;
        }
        PsiType component = JavaGenericsUtil.getCollectionItemType((PsiExpression)expr);
        if (component != null) {
            return new PsiTypeResult(GenericsUtil.getVariableTypeByExpressionType((PsiType)component), project2);
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/IterableComponentTypeMacro", "calculateQuickResult"));
        }
        return this.calculateResult(params, context);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

