/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Macro;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class MacroFactory {
    private static final MultiMap<String, Macro> myMacroTable = MacroFactory.init();

    public static Macro createMacro(@NonNls String name) {
        return (Macro)ContainerUtil.getFirstItem((Collection)myMacroTable.get((Object)name));
    }

    public static List<Macro> getMacros(@NonNls String name) {
        return (List)myMacroTable.get((Object)name);
    }

    public static Macro[] getMacros() {
        Collection values = myMacroTable.values();
        return values.toArray(new Macro[values.size()]);
    }

    private static MultiMap<String, Macro> init() {
        MultiMap result2 = MultiMap.create();
        for (Macro macro : (Macro[])Extensions.getExtensions((ExtensionPointName)Macro.EP_NAME)) {
            result2.putValue((Object)macro.getName(), (Object)macro);
        }
        return result2;
    }
}

