/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SplitWordsMacro
extends MacroBase {
    private final char mySeparator;

    private SplitWordsMacro(String name, String description, char separator) {
        super(name, description);
        this.mySeparator = separator;
    }

    @Override
    protected Result calculateResult(@NotNull Expression[] params, ExpressionContext context, boolean quick) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SplitWordsMacro", "calculateResult"));
        }
        String text = SplitWordsMacro.getTextResult(params, context, true);
        return text != null ? new TextResult(!text.isEmpty() ? this.convertString(text) : "") : null;
    }

    @VisibleForTesting
    public String convertString(String text) {
        return NameUtil.splitWords((String)text, (char)this.mySeparator, this::convertCase);
    }

    @NotNull
    protected abstract String convertCase(@NotNull String var1);

    public static class SpaceSeparated
    extends SplitWordsMacro {
        public SpaceSeparated() {
            super("spaceSeparated", "spaceSeparated(String)", ' ');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SpaceSeparated", "convertCase"));
            }
            String string = word;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SpaceSeparated", "convertCase"));
            }
            return string;
        }
    }

    public static class LowercaseAndDash
    extends SplitWordsMacro {
        public LowercaseAndDash() {
            super("lowercaseAndDash", "lowercaseAndDash(String)", '-');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/codeInsight/template/macro/SplitWordsMacro$LowercaseAndDash", "convertCase"));
            }
            String string = word.toLowerCase();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SplitWordsMacro$LowercaseAndDash", "convertCase"));
            }
            return string;
        }
    }

    public static class SnakeCaseMacro
    extends SplitWordsMacro {
        public SnakeCaseMacro() {
            super("snakeCase", "snakeCase(String)", '_');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SnakeCaseMacro", "convertCase"));
            }
            String string = word.toLowerCase();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SnakeCaseMacro", "convertCase"));
            }
            return string;
        }
    }
}

