/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.config.ActionUsagePanel;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PostfixDescriptionPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionDescriptionPanel");
    private JPanel myPanel;
    private JPanel myAfterPanel;
    private JPanel myBeforePanel;
    private JEditorPane myDescriptionBrowser;

    public PostfixDescriptionPanel() {
        this.$$$setupUI$$$();
        this.myDescriptionBrowser.setMargin(new Insets(5, 5, 5, 5));
        this.initializeExamplePanel(this.myAfterPanel);
        this.initializeExamplePanel(this.myBeforePanel);
    }

    public void reset(@NotNull PostfixTemplateMetaData actionMetaData) {
        if (actionMetaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionMetaData", "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel", "reset"));
        }
        boolean isEmpty = actionMetaData == PostfixTemplateMetaData.EMPTY_METADATA;
        this.myDescriptionBrowser.setText(isEmpty ? CodeInsightBundle.message((String)"templates.postfix.settings.category.text", (Object[])new Object[0]) : PostfixDescriptionPanel.getDescription(actionMetaData.getDescription()));
        PostfixDescriptionPanel.showUsages(this.myBeforePanel, isEmpty ? new PlainTextDescriptor(CodeInsightBundle.message((String)"templates.postfix.settings.category.before", (Object[])new Object[0]), "before.txt.template") : (TextDescriptor)ArrayUtil.getFirstElement((Object[])actionMetaData.getExampleUsagesBefore()));
        PostfixDescriptionPanel.showUsages(this.myAfterPanel, isEmpty ? new PlainTextDescriptor(CodeInsightBundle.message((String)"templates.postfix.settings.category.after", (Object[])new Object[0]), "after.txt.template") : (TextDescriptor)ArrayUtil.getFirstElement((Object[])actionMetaData.getExampleUsagesAfter()));
    }

    @NotNull
    private static String getDescription(TextDescriptor url) {
        String string;
        try {
            string = url.getText();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel", "getDescription"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel", "getDescription"));
        }
        return string;
    }

    private static void showUsages(@NotNull JPanel panel2, @Nullable TextDescriptor exampleUsage) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel", "showUsages"));
        }
        String text = "";
        PlainTextFileType fileType = PlainTextFileType.INSTANCE;
        if (exampleUsage != null) {
            try {
                text = exampleUsage.getText();
                String name = exampleUsage.getFileName();
                FileTypeManagerEx fileTypeManager = FileTypeManagerEx.getInstanceEx();
                String extension = fileTypeManager.getExtension(name);
                fileType = fileTypeManager.getFileTypeByExtension(extension);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        ((ActionUsagePanel)panel2.getComponent(0)).reset(text, (FileType)fileType);
        panel2.repaint();
    }

    private void initializeExamplePanel(@NotNull JPanel panel2) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel", "initializeExamplePanel"));
        }
        panel2.setLayout(new BorderLayout());
        ActionUsagePanel actionUsagePanel = new ActionUsagePanel();
        panel2.add(actionUsagePanel);
        Disposer.register((Disposable)this, (Disposable)actionUsagePanel);
    }

    synchronized JPanel getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAfterPanel = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 60), null, null));
        this.myBeforePanel = jPanel = new JPanel();
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 60), null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Before");
        jPanel4.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setAlignmentY(0.2f);
        titledSeparator2.setText("After");
        jPanel4.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myDescriptionBrowser = jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jBScrollPane.setViewportView(jEditorPane);
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Description");
        jPanel4.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

