/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatPostfixTemplate
extends StringBasedPostfixTemplate {
    private static final Condition<PsiElement> IS_STRING = expr -> {
        if (!(expr instanceof PsiExpression)) {
            return false;
        }
        PsiType type = ((PsiExpression)expr).getType();
        return type != null && "java.lang.String".equals(type.getCanonicalText());
    };

    public FormatPostfixTemplate() {
        super("format", "String.format(expr)", JavaPostfixTemplatesUtils.selectorAllExpressionsWithCurrentOffset(IS_STRING));
    }

    @Override
    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/postfix/templates/FormatPostfixTemplate", "getTemplateString"));
        }
        return "String.format($expr$, $END$)";
    }

    @Override
    protected PsiElement getElementToRemove(PsiElement expr) {
        return expr;
    }
}

