/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NumericOverflowInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Key<String> HAS_OVERFLOW_IN_CHILD = Key.create((String)"HAS_OVERFLOW_IN_CHILD");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.NUMERIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/NumericOverflowInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Numeric overflow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/NumericOverflowInspection", "getDisplayName"));
        }
        return "Numeric overflow";
    }

    @NotNull
    public String getShortName() {
        if ("NumericOverflow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/NumericOverflowInspection", "getShortName"));
        }
        return "NumericOverflow";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/NumericOverflowInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitExpression(PsiExpression expression) {
                boolean info = NumericOverflowInspection.hasOverflow(expression, holder.getProject());
                if (info) {
                    holder.registerProblem((PsiElement)expression, JavaErrorMessages.message("numeric.overflow.in.expression", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/NumericOverflowInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOverflow(PsiExpression expr, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/NumericOverflowInspection", "hasOverflow"));
        }
        if (!TypeConversionUtil.isNumericType((PsiType)expr.getType())) {
            return false;
        }
        boolean overflow = false;
        try {
            if (expr.getUserData(HAS_OVERFLOW_IN_CHILD) == null) {
                JavaPsiFacade.getInstance((Project)project2).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr, true);
            } else {
                overflow = true;
            }
        }
        catch (ConstantEvaluationOverflowException e) {
            overflow = true;
        }
        finally {
            PsiElement parent = expr.getParent();
            if (overflow && parent instanceof PsiExpression) {
                parent.putUserData(HAS_OVERFLOW_IN_CHILD, (Object)"");
            }
        }
        return overflow;
    }
}

