/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.offlineViewer.OfflineViewParseUtil;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewOfflineResultsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.actions.ViewOfflineResultsAction");
    @NonNls
    private static final String XML_EXTENSION = "xml";

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        presentation.setEnabled(project2 != null);
        presentation.setVisible(ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()) && !PlatformUtils.isCidr());
    }

    public void actionPerformed(AnActionEvent event) {
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        LOG.assertTrue(project2 != null);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public Icon getIcon(VirtualFile file2) {
                if (file2.isDirectory() && file2.findChild(".descriptions." + StdFileTypes.XML.getDefaultExtension()) != null) {
                    return AllIcons.Nodes.InspectionResults;
                }
                return super.getIcon(file2);
            }
        };
        descriptor.setTitle("Select Path");
        descriptor.setDescription("Select directory which contains exported inspections results");
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, null);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            return;
        }
        HashMap resMap = new HashMap();
        String[] profileName = new String[1];
        Runnable process2 = () -> {
            VirtualFile[] files = virtualFile.getChildren();
            try {
                for (final VirtualFile inspectionFile : files) {
                    if (inspectionFile.isDirectory()) continue;
                    String shortName = inspectionFile.getNameWithoutExtension();
                    String extension = inspectionFile.getExtension();
                    if (shortName.equals(".descriptions")) {
                        profileName[0] = (String)ReadAction.compute(() -> OfflineViewParseUtil.parseProfileName(LoadTextUtil.loadText(inspectionFile).toString()));
                        continue;
                    }
                    if (!XML_EXTENSION.equals(extension)) continue;
                    resMap.put(shortName, ApplicationManager.getApplication().runReadAction((Computable)new Computable<Map<String, Set<OfflineProblemDescriptor>>>(){

                        public Map<String, Set<OfflineProblemDescriptor>> compute() {
                            return OfflineViewParseUtil.parse(LoadTextUtil.loadText(inspectionFile).toString());
                        }
                    }));
                }
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> Messages.showInfoMessage((String)e.getMessage(), (String)InspectionsBundle.message((String)"offline.view.parse.exception.title", (Object[])new Object[0])));
                throw new ProcessCanceledException();
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(project2, InspectionsBundle.message((String)"parsing.inspections.dump.progress.title", (Object[])new Object[0]), process2, () -> SwingUtilities.invokeLater(() -> {
            String name = profileName[0];
            ViewOfflineResultsAction.showOfflineView(project2, name, resMap, InspectionsBundle.message((String)"offline.view.title", (Object[])new Object[0]) + " (" + (name != null ? name : InspectionsBundle.message((String)"offline.view.editor.settings.title", (Object[])new Object[0])) + ")");
        }), null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(project2));
    }

    public static InspectionResultsView showOfflineView(@NotNull Project project2, @Nullable String profileName, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull String title) {
        InspectionProfileImpl inspectionProfile;
        InspectionProfileImpl profile2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        if (resMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resMap", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        if (profileName != null) {
            profile2 = InspectionProjectProfileManager.getInstance(project2).getProfile(profileName, false);
            if (profile2 == null) {
                profile2 = InspectionProfileManager.getInstance().getProfile(profileName, false);
            }
        } else {
            profile2 = null;
        }
        if (profile2 != null) {
            inspectionProfile = profile2;
        } else {
            inspectionProfile = new InspectionProfileImpl(profileName != null ? profileName : "Server Side"){

                @Override
                public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key2, PsiElement element) {
                    if (key2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/actions/ViewOfflineResultsAction$3", "getErrorLevel"));
                    }
                    return InspectionProfileManager.getInstance().getCurrentProfile().getErrorLevel(key2, element);
                }
            };
            for (String id : resMap.keySet()) {
                inspectionProfile.enableTool(id, project2);
            }
        }
        return ViewOfflineResultsAction.showOfflineView(project2, resMap, inspectionProfile, title);
    }

    @NotNull
    public static InspectionResultsView showOfflineView(@NotNull Project project2, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull InspectionProfileImpl inspectionProfile, @NotNull String title) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        if (resMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resMap", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        AnalysisScope scope = new AnalysisScope(project2);
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project2);
        GlobalInspectionContextImpl context = managerEx.createNewGlobalContext(false);
        context.setExternalProfile(inspectionProfile);
        context.setCurrentScope(scope);
        context.initializeTools(new ArrayList<Tools>(), new ArrayList<Tools>(), new ArrayList<Tools>());
        InspectionResultsView view = new InspectionResultsView(context, new OfflineInspectionRVContentProvider(resMap, project2));
        ((RefManagerImpl)context.getRefManager()).startOfflineView();
        context.addView(view, title, true);
        view.update();
        InspectionResultsView inspectionResultsView = view;
        if (inspectionResultsView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        return inspectionResultsView;
    }
}

