/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedData;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

final class NegationInterpreter
extends BasicInterpreter {
    private final InsnList insns;

    NegationInterpreter(InsnList insns) {
        this.insns = insns;
    }

    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 3: {
                return AbstractValues.FalseValue;
            }
            case 4: {
                return AbstractValues.TrueValue;
            }
        }
        return super.newOperation(insn);
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opCode = insn.getOpcode();
        boolean shift = opCode != 184;
        int origin = this.insns.indexOf(insn);
        switch (opCode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                boolean stable = opCode == 184 || opCode == 183;
                MethodInsnNode mNode = (MethodInsnNode)insn;
                Method method2 = new Method(mNode.owner, mNode.name, mNode.desc);
                Type retType = Type.getReturnType((String)mNode.desc);
                BasicValue receiver = null;
                if (shift) {
                    receiver = values.remove(0);
                }
                boolean thisCall = (opCode == 185 || opCode == 182) && receiver == CombinedData.ThisValue;
                return new CombinedData.TrackableCallValue(origin, retType, method2, values, stable, thisCall);
            }
        }
        return super.naryOperation(insn, values);
    }
}

