/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.LoopAnalyzer;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveVariablesAnalyzer {
    private final DfaValueFactory myFactory;
    private final Instruction[] myInstructions;
    private final MultiMap<Instruction, Instruction> myForwardMap;
    private final MultiMap<Instruction, Instruction> myBackwardMap;
    private final FactoryMap<PsiElement, List<DfaVariableValue>> myClosureReads = new FactoryMap<PsiElement, List<DfaVariableValue>>(){

        @Nullable
        protected List<DfaVariableValue> create(PsiElement closure) {
            final LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
            closure.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    DfaValue value;
                    if (element instanceof PsiReferenceExpression && (value = LiveVariablesAnalyzer.this.myFactory.createValue((PsiExpression)((PsiReferenceExpression)element))) instanceof DfaVariableValue) {
                        result2.add((DfaVariableValue)value);
                    }
                    super.visitElement(element);
                }
            });
            return ContainerUtil.newArrayList((Iterable)result2);
        }
    };

    public LiveVariablesAnalyzer(ControlFlow flow, DfaValueFactory factory) {
        this.myFactory = factory;
        this.myInstructions = flow.getInstructions();
        this.myForwardMap = this.calcForwardMap();
        this.myBackwardMap = this.calcBackwardMap();
    }

    private List<Instruction> getSuccessors(Instruction ins) {
        return IntStreamEx.of((int[])LoopAnalyzer.getSuccessorIndices(ins.getIndex(), this.myInstructions)).mapToObj(i2 -> this.myInstructions[i2]).toList();
    }

    private MultiMap<Instruction, Instruction> calcBackwardMap() {
        MultiMap result2 = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            for (Instruction next : this.myForwardMap.get((Object)instruction)) {
                result2.putValue((Object)next, (Object)instruction);
            }
        }
        return result2;
    }

    private MultiMap<Instruction, Instruction> calcForwardMap() {
        MultiMap result2 = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            if (!this.isInterestingInstruction(instruction)) continue;
            block1: for (Instruction next : this.getSuccessors(instruction)) {
                while (true) {
                    if (this.isInterestingInstruction(next)) {
                        result2.putValue((Object)instruction, (Object)next);
                        continue block1;
                    }
                    if (next.getIndex() + 1 >= this.myInstructions.length) continue block1;
                    next = this.myInstructions[next.getIndex() + 1];
                }
            }
        }
        return result2;
    }

    @Nullable
    private static DfaVariableValue getWrittenVariable(Instruction instruction) {
        if (instruction instanceof AssignInstruction) {
            DfaValue value = ((AssignInstruction)instruction).getAssignedValue();
            return value instanceof DfaVariableValue ? (DfaVariableValue)value : null;
        }
        if (instruction instanceof FlushVariableInstruction) {
            return ((FlushVariableInstruction)instruction).getVariable();
        }
        return null;
    }

    @NotNull
    private List<DfaVariableValue> getReadVariables(Instruction instruction) {
        if (instruction instanceof PushInstruction && !((PushInstruction)instruction).isReferenceWrite()) {
            DfaValue value = ((PushInstruction)instruction).getValue();
            if (value instanceof DfaVariableValue) {
                List<DfaVariableValue> list = Collections.singletonList((DfaVariableValue)value);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer", "getReadVariables"));
                }
                return list;
            }
        } else {
            PsiElement closure = DfaUtil.getClosureInside(instruction);
            if (closure != null) {
                List list = (List)this.myClosureReads.get((Object)closure);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer", "getReadVariables"));
                }
                return list;
            }
        }
        List<DfaVariableValue> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer", "getReadVariables"));
        }
        return list;
    }

    private boolean isInterestingInstruction(Instruction instruction) {
        if (instruction == this.myInstructions[0]) {
            return true;
        }
        if (!this.getReadVariables(instruction).isEmpty() || LiveVariablesAnalyzer.getWrittenVariable(instruction) != null) {
            return true;
        }
        return instruction instanceof FinishElementInstruction || instruction instanceof GotoInstruction || instruction instanceof ConditionalGotoInstruction || instruction instanceof ControlTransferInstruction;
    }

    @Nullable
    private Map<FinishElementInstruction, BitSet> findLiveVars() {
        HashMap result2 = ContainerUtil.newHashMap();
        boolean ok = this.runDfa(false, (PairFunction<Instruction, BitSet, BitSet>)((PairFunction)(instruction, liveVars) -> {
            DfaVariableValue written;
            if (instruction instanceof FinishElementInstruction) {
                BitSet set2 = (BitSet)result2.get(instruction);
                if (set2 != null) {
                    set2.or((BitSet)liveVars);
                    return set2;
                }
                result2.put((FinishElementInstruction)instruction, liveVars);
            }
            if ((written = LiveVariablesAnalyzer.getWrittenVariable(instruction)) != null) {
                liveVars = (BitSet)liveVars.clone();
                liveVars.clear(written.getID());
                for (DfaVariableValue var : this.myFactory.getVarFactory().getAllQualifiedBy(written)) {
                    liveVars.clear(var.getID());
                }
            } else {
                boolean cloned = false;
                for (DfaVariableValue value : this.getReadVariables((Instruction)instruction)) {
                    if (liveVars.get(value.getID())) continue;
                    if (!cloned) {
                        liveVars = (BitSet)liveVars.clone();
                        cloned = true;
                    }
                    liveVars.set(value.getID());
                }
            }
            return liveVars;
        }));
        return ok ? result2 : null;
    }

    void flushDeadVariablesOnStatementFinish() {
        Map<FinishElementInstruction, BitSet> liveVars = this.findLiveVars();
        if (liveVars == null) {
            return;
        }
        MultiMap toFlush = MultiMap.createSet();
        boolean ok = this.runDfa(true, (PairFunction<Instruction, BitSet, BitSet>)((PairFunction)(instruction, prevLiveVars) -> {
            if (instruction instanceof FinishElementInstruction) {
                int setBit;
                BitSet currentlyLive = (BitSet)liveVars.get(instruction);
                if (currentlyLive == null) {
                    return new BitSet();
                }
                int index = 0;
                while ((setBit = prevLiveVars.nextSetBit(index)) >= 0) {
                    if (!currentlyLive.get(setBit)) {
                        toFlush.putValue((Object)((FinishElementInstruction)instruction), (Object)((DfaVariableValue)this.myFactory.getValue(setBit)));
                    }
                    index = setBit + 1;
                }
                return currentlyLive;
            }
            return prevLiveVars;
        }));
        if (ok) {
            for (FinishElementInstruction instruction2 : toFlush.keySet()) {
                instruction2.getVarsToFlush().addAll(toFlush.get((Object)instruction2));
            }
        }
    }

    private boolean runDfa(boolean forward, PairFunction<Instruction, BitSet, BitSet> handleState) {
        HashSet entryPoints = ContainerUtil.newHashSet();
        if (forward) {
            entryPoints.add(this.myInstructions[0]);
        } else {
            entryPoints.addAll(ContainerUtil.findAll((Object[])this.myInstructions, (Condition)FilteringIterator.instanceOf(ReturnInstruction.class)));
        }
        Queue queue = new Queue(10);
        for (Instruction i2 : entryPoints) {
            queue.addLast((Object)new InstructionState(i2, new BitSet()));
        }
        int limit = this.myForwardMap.size() * 20;
        HashSet processed2 = ContainerUtil.newHashSet();
        while (!queue.isEmpty()) {
            int steps = processed2.size();
            if (steps > limit) {
                return false;
            }
            if (steps % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            InstructionState state = (InstructionState)((Object)queue.pullFirst());
            Instruction instruction = (Instruction)state.first;
            Collection nextInstructions = forward ? this.myForwardMap.get((Object)instruction) : this.myBackwardMap.get((Object)instruction);
            BitSet nextVars = (BitSet)handleState.fun((Object)instruction, state.second);
            for (Instruction next : nextInstructions) {
                InstructionState nextState = new InstructionState(next, nextVars);
                if (!processed2.add(nextState)) continue;
                queue.addLast((Object)nextState);
            }
        }
        return true;
    }

    private static class InstructionState
    extends Pair<Instruction, BitSet> {
        public InstructionState(Instruction first, BitSet second) {
            super((Object)first, (Object)second);
        }
    }
}

