/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.deadCode.RefUnreachableFilter;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationInspectionBase
extends GlobalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + UnusedDeclarationInspectionBase.class.getName()));
    public boolean ADD_MAINS_TO_ENTRIES = true;
    public boolean ADD_APPLET_TO_ENTRIES = true;
    public boolean ADD_SERVLET_TO_ENTRIES = true;
    public boolean ADD_NONJAVA_TO_ENTRIES = true;
    private boolean TEST_ENTRY_POINTS = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
    public static final String SHORT_NAME = "unused";
    public static final String ALTERNATIVE_ID = "UnusedDeclaration";
    final List<EntryPoint> myExtensions = ContainerUtil.createLockFreeCopyOnWriteList();
    final UnusedSymbolLocalInspectionBase myLocalInspectionBase = this.createUnusedSymbolLocalInspection();
    private Set<RefElement> myProcessedSuspicious;
    private int myPhase;
    private final boolean myEnabledInEditor;

    public UnusedDeclarationInspectionBase() {
        this(!ApplicationManager.getApplication().isUnitTestMode());
    }

    public UnusedDeclarationInspectionBase(boolean enabledInEditor) {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        EntryPoint[] extensions = (EntryPoint[])point.getExtensions();
        ArrayList<EntryPoint> deadCodeAddIns = new ArrayList<EntryPoint>(extensions.length);
        for (EntryPoint entryPoint : extensions) {
            try {
                deadCodeAddIns.add(entryPoint.clone());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        Collections.sort(deadCodeAddIns, (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        this.myExtensions.addAll(deadCodeAddIns);
        this.myEnabledInEditor = enabledInEditor;
    }

    protected UnusedSymbolLocalInspectionBase createUnusedSymbolLocalInspection() {
        return new UnusedSymbolLocalInspectionBase();
    }

    @NotNull
    public UnusedSymbolLocalInspectionBase getSharedLocalInspectionTool() {
        UnusedSymbolLocalInspectionBase unusedSymbolLocalInspectionBase = this.myLocalInspectionBase;
        if (unusedSymbolLocalInspectionBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "getSharedLocalInspectionTool"));
        }
        return unusedSymbolLocalInspectionBase;
    }

    private boolean isAddMainsEnabled() {
        return this.ADD_MAINS_TO_ENTRIES;
    }

    private boolean isAddAppletEnabled() {
        return this.ADD_APPLET_TO_ENTRIES;
    }

    private boolean isAddServletEnabled() {
        return this.ADD_SERVLET_TO_ENTRIES;
    }

    private boolean isAddNonJavaUsedEnabled() {
        return this.ADD_NONJAVA_TO_ENTRIES;
    }

    public boolean isTestEntryPoints() {
        return this.TEST_ENTRY_POINTS;
    }

    public void setTestEntryPoints(boolean testEntryPoints) {
        this.TEST_ENTRY_POINTS = testEntryPoints;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        this.myLocalInspectionBase.readSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.readExternal(node);
        }
        String testEntriesAttr = node.getAttributeValue("test_entries");
        this.TEST_ENTRY_POINTS = testEntriesAttr == null || Boolean.parseBoolean(testEntriesAttr);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "writeSettings"));
        }
        this.myLocalInspectionBase.writeSettings(node);
        this.writeUnusedDeclarationSettings(node);
        if (!this.TEST_ENTRY_POINTS) {
            node.setAttribute("test_entries", Boolean.toString(false));
        }
    }

    protected void writeUnusedDeclarationSettings(Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (EntryPoint extension : this.myExtensions) {
            extension.writeExternal(node);
        }
    }

    private static boolean isExternalizableNoParameterConstructor(@NotNull PsiMethod method2, RefClass refClass) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isExternalizableNoParameterConstructor"));
        }
        if (!method2.isConstructor()) {
            return false;
        }
        if (!method2.hasModifierProperty("public")) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        if (parameterList.getParametersCount() != 0) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isExternalizable(aClass, refClass);
    }

    private static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isSerializationImplicitlyUsedField"));
        }
        String name = field.getName();
        if (!"serialVersionUID".equals(name) && !"serialPersistentFields".equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, null);
    }

    private static boolean isWriteObjectMethod(@NotNull PsiMethod method2, RefClass refClass) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isWriteObjectMethod"));
        }
        String name = method2.getName();
        if (!"writeObject".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(parameters[0].getType(), "java.io.ObjectOutputStream")) {
            return false;
        }
        if (method2.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isReadObjectMethod(@NotNull PsiMethod method2, RefClass refClass) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isReadObjectMethod"));
        }
        String name = method2.getName();
        if (!"readObject".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(parameters[0].getType(), "java.io.ObjectInputStream")) {
            return false;
        }
        if (method2.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isWriteReplaceMethod(@NotNull PsiMethod method2, RefClass refClass) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isWriteReplaceMethod"));
        }
        String name = method2.getName();
        if (!"writeReplace".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        if (parameters.length != 0) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(method2.getReturnType(), "java.lang.Object")) {
            return false;
        }
        if (method2.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean isReadResolveMethod(@NotNull PsiMethod method2, RefClass refClass) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isReadResolveMethod"));
        }
        String name = method2.getName();
        if (!"readResolve".equals(name)) {
            return false;
        }
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        if (parameters.length != 0) {
            return false;
        }
        if (!UnusedDeclarationInspectionBase.equalsToText(method2.getReturnType(), "java.lang.Object")) {
            return false;
        }
        if (method2.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        return aClass == null || UnusedDeclarationInspectionBase.isSerializable(aClass, refClass);
    }

    private static boolean equalsToText(PsiType type, String text) {
        return type != null && type.equalsToText(text);
    }

    private static boolean isSerializable(PsiClass aClass, @Nullable RefClass refClass) {
        PsiClass serializableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.io.Serializable", aClass.getResolveScope());
        return serializableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass, refClass, serializableClass);
    }

    private static boolean isExternalizable(@NotNull PsiClass aClass, RefClass refClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isExternalizable"));
        }
        GlobalSearchScope scope = aClass.getResolveScope();
        PsiClass externalizableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.io.Externalizable", scope);
        return externalizableClass != null && UnusedDeclarationInspectionBase.isSerializable(aClass, refClass, externalizableClass);
    }

    private static boolean isSerializable(PsiClass aClass, RefClass refClass, PsiClass serializableClass) {
        if (aClass == null) {
            return false;
        }
        if (aClass.isInheritor(serializableClass, true)) {
            return true;
        }
        if (refClass != null) {
            Set subClasses = refClass.getSubClasses();
            for (RefClass subClass : subClasses) {
                if (!UnusedDeclarationInspectionBase.isSerializable(subClass.getElement(), subClass, serializableClass)) continue;
                return true;
            }
        }
        return false;
    }

    public void runInspection(final @NotNull AnalysisScope scope, @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "runInspection"));
        }
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$1", "visitElement"));
                }
                if (refEntity instanceof RefElementImpl) {
                    RefElementImpl refElement = (RefElementImpl)refEntity;
                    if (!refElement.isSuspicious()) {
                        return;
                    }
                    PsiFile file2 = refElement.getContainingFile();
                    if (file2 == null) {
                        return;
                    }
                    boolean isSuppressed = refElement.isSuppressed(UnusedDeclarationInspectionBase.this.getShortName(), UnusedDeclarationInspectionBase.ALTERNATIVE_ID);
                    if (!(!isSuppressed && ((GlobalInspectionContextBase)globalContext).isToCheckFile(file2, (InspectionProfileEntry)UnusedDeclarationInspectionBase.this) || !isSuppressed && scope.contains((PsiElement)file2))) {
                        UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refElement, false);
                    }
                }
            }
        });
        if (this.isAddNonJavaUsedEnabled()) {
            this.checkForReachableRefs(globalContext);
            final StrictUnreferencedFilter strictUnreferencedFilter = new StrictUnreferencedFilter(this, globalContext);
            ProgressManager.getInstance().runProcess(new Runnable(){

                @Override
                public void run() {
                    final RefManager refManager = globalContext.getRefManager();
                    final PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)refManager.getProject());
                    refManager.iterate((RefVisitor)new RefJavaVisitor(){

                        public void visitElement(@NotNull RefEntity refEntity) {
                            RefMethod refMethod;
                            if (refEntity == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2$1", "visitElement"));
                            }
                            if (refEntity instanceof RefClass && strictUnreferencedFilter.accepts((RefJavaElement)((RefClass)refEntity))) {
                                this.findExternalClassReferences((RefClass)refEntity);
                            } else if (refEntity instanceof RefMethod && (refMethod = (RefMethod)refEntity).isConstructor() && strictUnreferencedFilter.accepts((RefJavaElement)refMethod)) {
                                this.findExternalClassReferences(refMethod.getOwnerClass());
                            }
                        }

                        private void findExternalClassReferences(RefClass refElement) {
                            PsiReference reference;
                            GlobalSearchScope projectScope;
                            DelegatingGlobalSearchScope globalSearchScope;
                            PsiNonJavaFileReferenceProcessor processor2;
                            String qualifiedName;
                            PsiClass psiClass = refElement.getElement();
                            String string = qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
                            if (qualifiedName != null && helper.processUsagesInNonJavaFiles(qualifiedName, processor2 = (file2, startOffset, endOffset) -> {
                                if (globalContext == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2$1", "lambda$findExternalClassReferences$0"));
                                }
                                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refElement, false);
                                return false;
                            }, (GlobalSearchScope)(globalSearchScope = new DelegatingGlobalSearchScope(projectScope = GlobalSearchScope.projectScope((Project)globalContext.getProject())){

                                public boolean contains(@NotNull VirtualFile file2) {
                                    if (file2 == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$2$1$1", "contains"));
                                    }
                                    return file2.getFileType() != JavaFileType.INSTANCE && super.contains(file2);
                                }
                            })) && (reference = (PsiReference)ReferencesSearch.search((PsiElement)psiClass, (SearchScope)globalSearchScope).findFirst()) != null) {
                                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refElement, false);
                                for (PsiMethod method2 : psiClass.getMethods()) {
                                    RefElement refMethod = refManager.getReference((PsiElement)method2);
                                    if (refMethod == null) continue;
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint(refMethod, false);
                                }
                            }
                        }
                    });
                }
            }, null);
        }
        this.myProcessedSuspicious = new HashSet<RefElement>();
        this.myPhase = 1;
    }

    public boolean isEntryPoint(@NotNull RefElement owner) {
        EntryPointsManager entryPointsManager;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isEntryPoint"));
        }
        PsiElement element = owner.getElement();
        if (UnusedDeclarationInspectionBase.isImplicitUsage(element)) {
            return true;
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)element.getProject())).isEntryPoint(element)) {
            return true;
        }
        if (element != null) {
            for (EntryPoint extension : this.myExtensions) {
                if (!extension.isSelected() || !extension.isEntryPoint(owner, element)) continue;
                return true;
            }
            if (this.isAddMainsEnabled() && owner instanceof RefMethod && ((RefMethod)owner).isAppMain()) {
                return true;
            }
            if (owner instanceof RefClass && (this.isAddAppletEnabled() && ((RefClass)owner).isApplet() || this.isAddServletEnabled() && ((RefClass)owner).isServlet())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isImplicitUsage(PsiElement element) {
        return element instanceof PsiField ? RefUtil.isImplicitRead((PsiElement)element) : RefUtil.isImplicitUsage((PsiElement)element);
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        EntryPointsManager entryPointsManager;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isEntryPoint"));
        }
        Project project2 = element.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        if (element instanceof PsiMethod && this.isAddMainsEnabled() && PsiClassImplUtil.isMainOrPremainMethod((PsiMethod)element)) {
            return true;
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiClass applet = psiFacade.findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project2));
            if (this.isAddAppletEnabled() && applet != null && aClass.isInheritor(applet, true)) {
                return true;
            }
            PsiClass servlet = psiFacade.findClass("javax.servlet.Servlet", GlobalSearchScope.allScope((Project)project2));
            if (this.isAddServletEnabled() && servlet != null && aClass.isInheritor(servlet, true)) {
                return true;
            }
            if (this.isAddMainsEnabled() && PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
                return true;
            }
        }
        if (element instanceof PsiModifierListOwner && (entryPointsManager = EntryPointsManager.getInstance((Project)project2)).isEntryPoint(element)) {
            return true;
        }
        for (EntryPoint extension : this.myExtensions) {
            if (!extension.isSelected() || !extension.isEntryPoint(element)) continue;
            return true;
        }
        return UnusedDeclarationInspectionBase.isImplicitUsage(element);
    }

    public boolean isGlobalEnabledInEditor() {
        return this.myEnabledInEditor;
    }

    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "queryExternalUsagesRequests"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "queryExternalUsagesRequests"));
        }
        this.checkForReachableRefs(globalContext);
        final RefUnreachableFilter filter = this.myPhase == 1 ? new StrictUnreferencedFilter(this, globalContext) : new RefUnreachableFilter(this, globalContext);
        LOG.assertTrue(this.myProcessedSuspicious != null, (Object)("phase: " + this.myPhase));
        final boolean[] requestAdded = new boolean[]{false};
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3", "visitElement"));
                }
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                if (refEntity instanceof RefClass && ((RefClass)refEntity).isAnonymous()) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (filter.accepts(refElement) && !UnusedDeclarationInspectionBase.this.myProcessedSuspicious.contains(refElement)) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitField(@NotNull RefField refField) {
                            if (refField == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refField", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "visitField"));
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refField);
                            PsiField psiField = refField.getElement();
                            if (psiField != null && UnusedDeclarationInspectionBase.isSerializationImplicitlyUsedField(psiField)) {
                                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refField, false);
                            } else {
                                ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueFieldUsagesProcessor(refField, psiReference -> {
                                    if (globalContext == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "lambda$visitField$0"));
                                    }
                                    if (refField == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refField", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "lambda$visitField$0"));
                                    }
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refField, false);
                                    return false;
                                });
                                requestAdded[0] = true;
                            }
                        }

                        public void visitMethod(@NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "visitMethod"));
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refMethod);
                            if (refMethod instanceof RefImplicitConstructor) {
                                this.visitClass(refMethod.getOwnerClass());
                            } else {
                                PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
                                if (psiMethod != null && UnusedDeclarationInspectionBase.isSerializablePatternMethod(psiMethod, refMethod.getOwnerClass())) {
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refMethod, false);
                                } else if (!refMethod.isExternalOverride() && !"private".equals(refMethod.getAccessModifier())) {
                                    for (RefMethod derivedMethod : refMethod.getDerivedMethods()) {
                                        UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(derivedMethod);
                                    }
                                    UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refMethod);
                                    requestAdded[0] = true;
                                }
                            }
                        }

                        public void visitClass(@NotNull RefClass refClass) {
                            if (refClass == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "visitClass"));
                            }
                            UnusedDeclarationInspectionBase.this.myProcessedSuspicious.add(refClass);
                            if (!refClass.isAnonymous()) {
                                ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueDerivedClassesProcessor(refClass, inheritor -> {
                                    if (globalContext == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "lambda$visitClass$1"));
                                    }
                                    if (refClass == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "lambda$visitClass$1"));
                                    }
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refClass, false);
                                    return false;
                                });
                                ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueClassUsagesProcessor(refClass, psiReference -> {
                                    if (globalContext == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "lambda$visitClass$2"));
                                    }
                                    if (refClass == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$3$1", "lambda$visitClass$2"));
                                    }
                                    UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refClass, false);
                                    return false;
                                });
                                requestAdded[0] = true;
                            }
                        }
                    });
                }
            }
        });
        if (!requestAdded[0]) {
            if (this.myPhase == 2) {
                this.myProcessedSuspicious = null;
                return false;
            }
            this.myPhase = 2;
        }
        return true;
    }

    private static boolean isSerializablePatternMethod(@NotNull PsiMethod psiMethod, RefClass refClass) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "isSerializablePatternMethod"));
        }
        return UnusedDeclarationInspectionBase.isReadObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteObjectMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isReadResolveMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isWriteReplaceMethod(psiMethod, refClass) || UnusedDeclarationInspectionBase.isExternalizableNoParameterConstructor(psiMethod, refClass);
    }

    private static void enqueueMethodUsages(GlobalInspectionContext globalContext, RefMethod refMethod) {
        if (refMethod.getSuperMethods().isEmpty()) {
            ((GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)).enqueueMethodUsagesProcessor(refMethod, psiReference -> {
                UnusedDeclarationInspectionBase.getEntryPointsManager(globalContext).addEntryPoint((RefElement)refMethod, false);
                return false;
            });
        } else {
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                UnusedDeclarationInspectionBase.enqueueMethodUsages(globalContext, refSuper);
            }
        }
    }

    @Nullable
    public JobDescriptor[] getAdditionalJobs(GlobalInspectionContext context) {
        return new JobDescriptor[]{context.getStdJobDescriptors().BUILD_GRAPH, context.getStdJobDescriptors().FIND_EXTERNAL_USAGES};
    }

    void checkForReachableRefs(final @NotNull GlobalInspectionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase", "checkForReachableRefs"));
        }
        CodeScanner codeScanner = new CodeScanner();
        context.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$4", "visitElement"));
                }
                if (refEntity instanceof RefJavaElementImpl) {
                    RefJavaElementImpl refElement = (RefJavaElementImpl)refEntity;
                    if (!((GlobalInspectionContextBase)context).isToCheckMember(refElement, (InspectionProfileEntry)UnusedDeclarationInspectionBase.this)) {
                        return;
                    }
                    refElement.setReachable(false);
                }
            }
        });
        for (RefElement entry : UnusedDeclarationInspectionBase.getEntryPointsManager(context).getEntryPoints()) {
            entry.accept((RefVisitor)codeScanner);
        }
        while (codeScanner.newlyInstantiatedClassesCount() != 0) {
            codeScanner.cleanInstantiatedClassesCount();
            codeScanner.processDelayedMethods();
        }
    }

    private static EntryPointsManager getEntryPointsManager(GlobalInspectionContext context) {
        return ((GlobalJavaInspectionContext)context.getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(context.getRefManager());
    }

    public List<EntryPoint> getExtensions() {
        return this.myExtensions;
    }

    private static class CodeScanner
    extends RefJavaVisitor {
        private final Map<RefClass, Set<RefMethod>> myClassIDtoMethods = new HashMap();
        private final Set<RefClass> myInstantiatedClasses = new HashSet<RefClass>();
        private int myInstantiatedClassesCount;
        private final Set<RefMethod> myProcessedMethods = new HashSet<RefMethod>();

        private CodeScanner() {
        }

        public void visitMethod(@NotNull RefMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner", "visitMethod"));
            }
            if (!this.myProcessedMethods.contains(method2)) {
                if (method2.isStatic() || method2.isConstructor()) {
                    if (method2.isConstructor()) {
                        this.addInstantiatedClass(method2.getOwnerClass());
                    } else {
                        ((RefClassImpl)method2.getOwnerClass()).setReachable(true);
                    }
                    this.myProcessedMethods.add(method2);
                    this.makeContentReachable((RefJavaElementImpl)method2);
                    this.makeClassInitializersReachable(method2.getOwnerClass());
                } else {
                    if (this.isClassInstantiated(method2.getOwnerClass())) {
                        this.myProcessedMethods.add(method2);
                        this.makeContentReachable((RefJavaElementImpl)method2);
                    } else {
                        this.addDelayedMethod(method2);
                    }
                    for (RefMethod refSub : method2.getDerivedMethods()) {
                        this.visitMethod(refSub);
                    }
                }
            }
        }

        public void visitClass(@NotNull RefClass refClass) {
            if (refClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner", "visitClass"));
            }
            boolean alreadyActive = refClass.isReachable();
            ((RefClassImpl)refClass).setReachable(true);
            if (!alreadyActive) {
                this.makeClassInitializersReachable(refClass);
            }
            this.addInstantiatedClass(refClass);
        }

        public void visitField(@NotNull RefField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$CodeScanner", "visitField"));
            }
            if (!field.isReachable()) {
                this.makeContentReachable((RefJavaElementImpl)field);
                this.makeClassInitializersReachable(field.getOwnerClass());
            }
        }

        private void addInstantiatedClass(RefClass refClass) {
            if (this.myInstantiatedClasses.add(refClass)) {
                ((RefClassImpl)refClass).setReachable(true);
                ++this.myInstantiatedClassesCount;
                List refMethods = refClass.getLibraryMethods();
                for (RefMethod refMethod : refMethods) {
                    refMethod.accept((RefVisitor)this);
                }
                for (RefClass baseClass : refClass.getBaseClasses()) {
                    this.addInstantiatedClass(baseClass);
                }
            }
        }

        private void makeContentReachable(RefJavaElementImpl refElement) {
            refElement.setReachable(true);
            for (RefElement refCallee : refElement.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void makeClassInitializersReachable(RefClass refClass) {
            for (RefElement refCallee : refClass.getOutReferences()) {
                refCallee.accept((RefVisitor)this);
            }
        }

        private void addDelayedMethod(RefMethod refMethod) {
            Set<RefMethod> methods = this.myClassIDtoMethods.get(refMethod.getOwnerClass());
            if (methods == null) {
                methods = new HashSet<RefMethod>();
                this.myClassIDtoMethods.put(refMethod.getOwnerClass(), methods);
            }
            methods.add(refMethod);
        }

        private boolean isClassInstantiated(RefClass refClass) {
            return this.myInstantiatedClasses.contains(refClass);
        }

        private int newlyInstantiatedClassesCount() {
            return this.myInstantiatedClassesCount;
        }

        private void cleanInstantiatedClassesCount() {
            this.myInstantiatedClassesCount = 0;
        }

        private void processDelayedMethods() {
            RefClass[] instClasses;
            for (RefClass refClass : instClasses = this.myInstantiatedClasses.toArray(new RefClass[this.myInstantiatedClasses.size()])) {
                RefMethod[] arMethods;
                Set<RefMethod> methods;
                if (!this.isClassInstantiated(refClass) || (methods = this.myClassIDtoMethods.get(refClass)) == null) continue;
                for (RefMethod arMethod : arMethods = methods.toArray(new RefMethod[methods.size()])) {
                    arMethod.accept((RefVisitor)this);
                }
            }
        }
    }

    private static class StrictUnreferencedFilter
    extends UnreferencedFilter {
        private StrictUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContext context) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter", "<init>"));
            }
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            if (refElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase$StrictUnreferencedFilter", "getElementProblemCount"));
            }
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            return refElement.isReferenced() ? 0 : 1;
        }
    }
}

