/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defaultFileTemplateUsage;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.defaultFileTemplateUsage.DefaultFileTemplateUsageInspection;
import com.intellij.codeInspection.defaultFileTemplateUsage.ReplaceWithFileTemplateFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FileHeaderChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.defaultFileTemplateUsage.FileHeaderChecker");

    static ProblemDescriptor checkFileHeader(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean onTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "checkFileHeader"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "checkFileHeader"));
        }
        TIntObjectHashMap offsetToProperty = new TIntObjectHashMap();
        FileTemplate defaultTemplate = FileTemplateManager.getInstance(file2.getProject()).getDefaultTemplate("File Header");
        Pattern pattern = FileTemplateUtil.getTemplatePattern(defaultTemplate, file2.getProject(), (TIntObjectHashMap<String>)offsetToProperty);
        Matcher matcher = pattern.matcher(file2.getViewProvider().getContents());
        if (!matcher.matches()) {
            return null;
        }
        PsiComment element = (PsiComment)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)matcher.start(1), (int)matcher.end(1), PsiComment.class);
        if (element == null) {
            return null;
        }
        LocalQuickFix[] fixes = FileHeaderChecker.createQuickFix(matcher, (TIntObjectHashMap<String>)offsetToProperty, file2.getProject(), onTheFly);
        String description = InspectionsBundle.message((String)"default.file.template.description", (Object[])new Object[0]);
        return manager.createProblemDescriptor((PsiElement)element, description, onTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static Properties computeProperties(Matcher matcher, TIntObjectHashMap<String> offsetToProperty, Project project2) {
        Properties properties = new Properties(FileTemplateManager.getInstance(project2).getDefaultProperties());
        int[] offsets = offsetToProperty.keys();
        Arrays.sort(offsets);
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            String propName = (String)offsetToProperty.get(offset);
            int groupNum = i + 2;
            String propValue = matcher.group(groupNum);
            properties.setProperty(propName, propValue);
        }
        return properties;
    }

    private static LocalQuickFix[] createQuickFix(final Matcher matcher, final TIntObjectHashMap<String> offsetToProperty, Project project2, boolean onTheFly) {
        LocalQuickFix[] localQuickFixArray;
        final FileTemplate template = FileTemplateManager.getInstance(project2).getPattern("File Header");
        ReplaceWithFileTemplateFix replaceTemplateFix = new ReplaceWithFileTemplateFix(){

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                String newText;
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker$1", "applyFix"));
                }
                PsiElement element = descriptor.getPsiElement();
                if (element == null) {
                    return;
                }
                try {
                    newText = template.getText(FileHeaderChecker.computeProperties(matcher, (TIntObjectHashMap<String>)offsetToProperty, project2)).trim();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                if (!newText.isEmpty()) {
                    PsiElement parent = element.getParent();
                    PsiFile tempFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("template.java", (FileType)JavaFileType.INSTANCE, (CharSequence)newText);
                    for (PsiElement child : tempFile.getChildren()) {
                        if (child.getTextLength() <= 0) continue;
                        parent.addBefore(child, element);
                    }
                }
                element.delete();
            }
        };
        if (onTheFly) {
            LocalQuickFix[] localQuickFixArray2;
            LocalQuickFix editFileTemplateFix = DefaultFileTemplateUsageInspection.createEditFileTemplateFix(template, replaceTemplateFix);
            if (template.isDefault()) {
                LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                localQuickFixArray2 = localQuickFixArray3;
                localQuickFixArray3[0] = editFileTemplateFix;
            } else {
                LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[2];
                localQuickFixArray4[0] = replaceTemplateFix;
                localQuickFixArray2 = localQuickFixArray4;
                localQuickFixArray4[1] = editFileTemplateFix;
            }
            return localQuickFixArray2;
        }
        if (template.isDefault()) {
            localQuickFixArray = null;
        } else {
            LocalQuickFix[] localQuickFixArray5 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray5;
            localQuickFixArray5[0] = replaceTemplateFix;
        }
        return localQuickFixArray;
    }
}

