/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileLoadUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileProcessor;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProfileManager", storages={@Storage(value="editor.xml"), @Storage(value="other.xml", deprecated=true)}, additionalExportFile="inspection")
public class ApplicationInspectionProfileManager
extends BaseInspectionProfileManager
implements InspectionProfileManager,
PersistentStateComponent<Element> {
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledInspectionProfile");
    private final InspectionToolRegistrar myRegistrar;
    private final SchemeManager<InspectionProfileImpl> mySchemeManager;
    private final AtomicBoolean myProfilesAreInitialized;
    private volatile boolean LOAD_PROFILES;

    public static ApplicationInspectionProfileManager getInstanceImpl() {
        return (ApplicationInspectionProfileManager)ServiceManager.getService(InspectionProfileManager.class);
    }

    public ApplicationInspectionProfileManager(@NotNull InspectionToolRegistrar registrar, @NotNull SchemeManagerFactory schemeManagerFactory, @NotNull MessageBus messageBus) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "<init>"));
        }
        if (schemeManagerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeManagerFactory", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "<init>"));
        }
        super(messageBus);
        this.myProfilesAreInitialized = new AtomicBoolean(false);
        this.LOAD_PROFILES = !ApplicationManager.getApplication().isUnitTestMode();
        this.myRegistrar = registrar;
        ApplicationInspectionProfileManager.registerProvidedSeverities();
        this.mySchemeManager = schemeManagerFactory.create("inspection", new InspectionProfileProcessor(){

            @Override
            @NotNull
            public String getName(@NotNull Function<String, String> attributeProvider2, @NotNull String fileNameWithoutExtension) {
                if (attributeProvider2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeProvider", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "getName"));
                }
                if (fileNameWithoutExtension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "getName"));
                }
                String string = fileNameWithoutExtension;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "getName"));
                }
                return string;
            }

            @Override
            @NotNull
            public InspectionProfileImpl createScheme(@NotNull SchemeDataHolder<? super InspectionProfileImpl> dataHolder, @NotNull String name, @NotNull Function<String, String> attributeProvider2, boolean isBundled) {
                if (dataHolder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "createScheme"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "createScheme"));
                }
                if (attributeProvider2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeProvider", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "createScheme"));
                }
                InspectionProfileImpl inspectionProfileImpl = new InspectionProfileImpl(name, ApplicationInspectionProfileManager.this.myRegistrar, ApplicationInspectionProfileManager.this, dataHolder);
                if (inspectionProfileImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "createScheme"));
                }
                return inspectionProfileImpl;
            }

            @Override
            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme2) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "onSchemeAdded"));
                }
                ApplicationInspectionProfileManager.this.fireProfileChanged(scheme2);
                ApplicationInspectionProfileManager.onProfilesChanged();
            }

            @Override
            public void onSchemeDeleted(@NotNull InspectionProfileImpl scheme2) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1", "onSchemeDeleted"));
                }
                ApplicationInspectionProfileManager.onProfilesChanged();
            }
        });
    }

    @Override
    @NotNull
    protected SchemeManager<InspectionProfileImpl> getSchemeManager() {
        SchemeManager<InspectionProfileImpl> schemeManager2 = this.mySchemeManager;
        if (schemeManager2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "getSchemeManager"));
        }
        return schemeManager2;
    }

    public static void registerProvidedSeverities() {
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType t : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = t.getSeverity(null);
                SeverityRegistrar.registerStandard(t, highlightSeverity);
                TextAttributesKey attributesKey = t.getAttributesKey();
                Icon icon = t instanceof HighlightInfoType.Iconable ? ((HighlightInfoType.Iconable)((Object)t)).getIcon() : null;
                HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (TextAttributesKey)attributesKey, (Icon)icon);
            }
        }
    }

    @Override
    @NotNull
    public Collection<InspectionProfileImpl> getProfiles() {
        this.initProfiles();
        List<InspectionProfileImpl> list = Collections.unmodifiableList(this.mySchemeManager.getAllSchemes());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "getProfiles"));
        }
        return list;
    }

    public void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.myProfilesAreInitialized.set(false);
    }

    public void initProfiles() {
        if (!this.myProfilesAreInitialized.compareAndSet(false, true) || !this.LOAD_PROFILES) {
            return;
        }
        this.loadBundledSchemes();
        this.mySchemeManager.loadSchemes();
        if (this.mySchemeManager.isEmpty()) {
            this.mySchemeManager.addScheme(new InspectionProfileImpl("Default", InspectionToolRegistrar.getInstance(), this));
        }
    }

    private void loadBundledSchemes() {
        if (!ApplicationInspectionProfileManager.isUnitTestOrHeadlessMode()) {
            for (BundledSchemeEP ep : (BundledSchemeEP[])BUNDLED_EP_NAME.getExtensions()) {
                this.mySchemeManager.loadBundledScheme(ep.getPath() + ".xml", (Object)ep);
            }
        }
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public InspectionProfileImpl loadProfile(@NotNull String path) throws IOException, JDOMException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "loadProfile"));
        }
        Path file2 = Paths.get(path, new String[0]);
        if (Files.isRegularFile(file2, new LinkOption[0])) {
            try {
                return InspectionProfileLoadUtil.load(file2, this.myRegistrar, (InspectionProfileManager)this);
            }
            catch (IOException | JDOMException e) {
                throw e;
            }
            catch (Exception ignored) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, file2}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0])), ModalityState.NON_MODAL);
            }
        }
        return this.getProfile(path, false);
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.getSeverityRegistrar().writeExternal(state);
        return state;
    }

    public void loadState(Element state) {
        this.getSeverityRegistrar().readExternal(state);
    }

    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    @Override
    public void setRootProfile(@Nullable String profileName) {
        this.mySchemeManager.setCurrentSchemeName(profileName);
    }

    @Override
    public InspectionProfileImpl getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "getProfile"));
        }
        InspectionProfileImpl found = this.mySchemeManager.findSchemeByName(name);
        if (found != null) {
            return found;
        }
        if (returnRootProfileIfNamedIsAbsent) {
            return this.getCurrentProfile();
        }
        return null;
    }

    @Override
    @NotNull
    public InspectionProfileImpl getCurrentProfile() {
        this.initProfiles();
        InspectionProfileImpl current = this.mySchemeManager.getCurrentScheme();
        if (current != null) {
            InspectionProfileImpl inspectionProfileImpl = current;
            if (inspectionProfileImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "getCurrentProfile"));
            }
            return inspectionProfileImpl;
        }
        InspectionProfileImpl result2 = this.mySchemeManager.findSchemeByName("Default");
        if (result2 == null) {
            InspectionProfileImpl inspectionProfileImpl = new InspectionProfileImpl("Default", InspectionToolRegistrar.getInstance(), this, null, null);
            if (inspectionProfileImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "getCurrentProfile"));
            }
            return inspectionProfileImpl;
        }
        InspectionProfileImpl inspectionProfileImpl = result2;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "getCurrentProfile"));
        }
        return inspectionProfileImpl;
    }

    @NotNull
    public String getRootProfileName() {
        String string = (String)ObjectUtils.chooseNotNull((Object)this.mySchemeManager.getCurrentSchemeName(), (Object)"Default");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "getRootProfileName"));
        }
        return string;
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager", "fireProfileChanged"));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            ProjectInspectionProfileManager.getInstance(project2).fireProfileChanged(profile2);
        }
        ApplicationInspectionProfileManager.onProfilesChanged();
    }

    public static void onProfilesChanged() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            AppUIUtil.invokeLaterIfProjectAlive(project2, () -> DaemonListeners.getInstance(project2).updateStatusBar());
        }
    }
}

