/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditInspectionToolsSettingsInSuppressedPlaceIntention
implements IntentionAction {
    private String myId;
    private String myDisplayName;

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"edit.options.of.reporter.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"edit.inspection.options", (Object[])new Object[]{this.myDisplayName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention", "getText"));
        }
        return string;
    }

    @Nullable
    private static String getSuppressedId(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        for (PsiElement element = file2.findElementAt(offset); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
                String suppressedIds = factory.getSuppressedInspectionIdsIn(element);
                if (suppressedIds == null) continue;
                for (String id : StringUtil.split((String)suppressedIds, (String)",")) {
                    if (!EditInspectionToolsSettingsInSuppressedPlaceIntention.isCaretOnSuppressedId(file2, offset, id)) continue;
                    return id;
                }
            }
        }
        return null;
    }

    private static boolean isCaretOnSuppressedId(PsiFile file2, int caretOffset, String suppressedId) {
        int end;
        int start;
        CharSequence fileText = file2.getViewProvider().getContents();
        return StringUtil.indexOf((CharSequence)fileText.subSequence(start = Math.max(0, caretOffset - suppressedId.length()), end = Math.min(caretOffset + suppressedId.length(), fileText.length())), (CharSequence)suppressedId) >= 0;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention", "isAvailable"));
        }
        this.myId = EditInspectionToolsSettingsInSuppressedPlaceIntention.getSuppressedId(editor, file2);
        if (this.myId != null) {
            InspectionToolWrapper toolWrapper = this.getTool(project2, file2);
            if (toolWrapper == null) {
                return false;
            }
            this.myDisplayName = toolWrapper.getDisplayName();
        }
        return this.myId != null;
    }

    @Nullable
    private InspectionToolWrapper getTool(Project project2, PsiFile file2) {
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        return inspectionProfile.getToolById(this.myId, (PsiElement)file2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention", "invoke"));
        }
        InspectionToolWrapper toolWrapper = this.getTool(project2, file2);
        if (toolWrapper == null) {
            return;
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project2, inspectionProfile, toolWrapper.getShortName());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

