/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class InspectionSearchableOptionContributor
extends SearchableOptionContributor {
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

    public void processOptions(@NotNull SearchableOptionProcessor processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/ex/InspectionSearchableOptionContributor", "processOptions"));
        }
        for (InspectionToolWrapper toolWrapper : InspectionToolRegistrar.getInstance().createTools()) {
            String hit = toolWrapper.getDisplayName();
            processor2.addOptions(toolWrapper.getDisplayName(), toolWrapper.getShortName(), hit, "Errors", "Inspections", false);
            for (String group : toolWrapper.getGroupPath()) {
                processor2.addOptions(group, toolWrapper.getShortName(), hit, "Errors", "Inspections", false);
            }
            String description = toolWrapper.loadDescription();
            if (description == null) continue;
            String descriptionText = HTML_PATTERN.matcher(description).replaceAll(" ");
            processor2.addOptions(descriptionText, toolWrapper.getShortName(), hit, "Errors", "Inspections", false);
        }
    }
}

