/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlWrongRootElementInspection
extends HtmlLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.XML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspection.wrong.root.element", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("XmlWrongRootElement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection", "getShortName"));
        }
        return "XmlWrongRootElement";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection", "checkTag"));
        }
        if (!(tag.getParent() instanceof XmlTag)) {
            PsiFile psiFile = tag.getContainingFile();
            if (!(psiFile instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)psiFile;
            XmlDocument document = xmlFile.getDocument();
            if (document == null) {
                return;
            }
            XmlProlog prolog = document.getProlog();
            if (prolog == null || XmlHighlightVisitor.skipValidation((PsiElement)prolog)) {
                return;
            }
            XmlDoctype doctype = prolog.getDoctype();
            if (doctype == null) {
                return;
            }
            XmlElement nameElement = doctype.getNameElement();
            if (nameElement == null) {
                return;
            }
            String name = tag.getName();
            String text = nameElement.getText();
            if (tag instanceof HtmlTag) {
                name = name.toLowerCase();
                text = text.toLowerCase();
            }
            if (!name.equals(text) && !(name = XmlUtil.findLocalNameByQualifiedName(name)).equals(text)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                MyLocalQuickFix localQuickFix = new MyLocalQuickFix(doctype.getNameElement().getText());
                holder.registerProblem(XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode()).getPsi(), XmlErrorMessages.message("wrong.root.element", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                ASTNode astNode = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag.getNode());
                if (astNode != null) {
                    holder.registerProblem(astNode.getPsi(), XmlErrorMessages.message("wrong.root.element", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{localQuickFix});
                }
            }
        }
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private final String myText;

        public MyLocalQuickFix(String text) {
            this.myText = text;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlBundle.message((String)"change.root.element.to", (Object[])new Object[]{this.myText});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$MyLocalQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$MyLocalQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/XmlWrongRootElementInspection$MyLocalQuickFix", "applyFix"));
            }
            XmlTag myTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class);
            myTag.setName(this.myText);
        }
    }
}

