/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JavaModuleNamingInspection
extends BaseJavaLocalInspectionTool {
    private final Pattern TRAILING_DIGITS = Pattern.compile("^([^0-9]+)\\d+$");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection", "buildVisitor"));
        }
        Object object = !PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? PsiElementVisitor.EMPTY_VISITOR : new JavaElementVisitor(){

            public void visitModule(PsiJavaModule module2) {
                super.visitModule(module2);
                PsiJavaModuleReferenceElement nameElement = module2.getNameIdentifier();
                String name = nameElement.getReferenceText();
                Matcher matcher = JavaModuleNamingInspection.this.TRAILING_DIGITS.matcher(name);
                if (matcher.matches()) {
                    String message = InspectionsBundle.message((String)"inspection.java.module.naming.terminal.digits", (Object[])new Object[]{name});
                    holder.registerProblem((PsiElement)nameElement, message, new LocalQuickFix[]{QuickFixFactory.getInstance().createRenameElementFix((PsiNamedElement)module2, matcher.group(1))});
                }
            }
        };
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/JavaModuleNamingInspection", "buildVisitor"));
        }
        return object;
    }
}

