/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import org.jetbrains.annotations.NotNull;

class ChangeNullableDefaultsFix
implements LocalQuickFix {
    private final NullableNotNullManager myManager;
    private final String myNotNullName;
    private final String myNullableName;

    public ChangeNullableDefaultsFix(PsiAnnotation notNull, PsiAnnotation nullable, NullableNotNullManager manager) {
        this.myNotNullName = notNull != null ? notNull.getQualifiedName() : null;
        this.myNullableName = nullable != null ? nullable.getQualifiedName() : null;
        this.myManager = manager;
    }

    ChangeNullableDefaultsFix(String notNull, String nullable, NullableNotNullManager manager) {
        this.myManager = manager;
        this.myNotNullName = notNull;
        this.myNullableName = nullable;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Make \"" + (this.myNotNullName != null ? this.myNotNullName : this.myNullableName) + "\" default annotation";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/ChangeNullableDefaultsFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/nullable/ChangeNullableDefaultsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/nullable/ChangeNullableDefaultsFix", "applyFix"));
        }
        if (this.myNotNullName != null) {
            this.myManager.setDefaultNotNull(this.myNotNullName);
        } else {
            this.myManager.setDefaultNullable(this.myNullableName);
        }
    }
}

