/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RefEntityImpl
implements RefEntity {
    private volatile RefEntityImpl myOwner;
    protected List<RefEntity> myChildren;
    private final String myName;
    private Map<Key, Object> myUserMap;
    protected long myFlags;
    protected final RefManagerImpl myManager;

    RefEntityImpl(@NotNull String name, @NotNull RefManager manager) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefEntityImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefEntityImpl", "<init>"));
        }
        this.myManager = (RefManagerImpl)manager;
        this.myName = this.myManager.internName(name);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public synchronized List<RefEntity> getChildren() {
        List list = (List)ObjectUtils.notNull(this.myChildren, (Object)ContainerUtil.emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getChildren"));
        }
        return list;
    }

    public RefEntity getOwner() {
        return this.myOwner;
    }

    protected void setOwner(@Nullable RefEntityImpl owner) {
        this.myOwner = owner;
    }

    public synchronized void add(@NotNull RefEntity child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInspection/reference/RefEntityImpl", "add"));
        }
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<RefEntity>(1);
        }
        this.myChildren.add(child);
        ((RefEntityImpl)child).setOwner(this);
    }

    protected synchronized void removeChild(@NotNull RefEntity child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInspection/reference/RefEntityImpl", "removeChild"));
        }
        if (this.myChildren != null) {
            this.myChildren.remove(child);
            ((RefEntityImpl)child).setOwner(null);
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/reference/RefEntityImpl", "getUserData"));
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                return null;
            }
            return (T)this.myUserMap.get(key2);
        }
    }

    public void accept(@NotNull RefVisitor refVisitor) {
        if (refVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refVisitor", "com/intellij/codeInspection/reference/RefEntityImpl", "accept"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (refVisitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refVisitor", "com/intellij/codeInspection/reference/RefEntityImpl", "lambda$accept$0"));
            }
            refVisitor.visitElement((RefEntity)this);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putUserData(@NotNull Key<T> key2, T value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/reference/RefEntityImpl", "putUserData"));
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                if (value == null) {
                    return;
                }
                this.myUserMap = new THashMap();
            }
            if (value != null) {
                this.myUserMap.put(key2, value);
            } else {
                this.myUserMap.remove(key2);
                if (this.myUserMap.isEmpty()) {
                    this.myUserMap = null;
                }
            }
        }
    }

    public boolean checkFlag(long mask) {
        return BitUtil.isSet((long)this.myFlags, (long)mask);
    }

    public void setFlag(boolean value, long mask) {
        this.myFlags = BitUtil.set((long)this.myFlags, (long)mask, (boolean)value);
    }

    public String getExternalName() {
        return this.myName;
    }

    @NotNull
    public RefManagerImpl getRefManager() {
        RefManagerImpl refManagerImpl = this.myManager;
        if (refManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getRefManager"));
        }
        return refManagerImpl;
    }
}

