/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

class FindFirstMigration
extends BaseStreamApiMigration {
    FindFirstMigration() {
        super("findFirst()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body, @NotNull TerminalBlock tb) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/FindFirstMigration", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/FindFirstMigration", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/FindFirstMigration", "migrate"));
        }
        PsiStatement statement2 = tb.getSingleStatement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiLoopStatement loopStatement = tb.getMainLoop();
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            PsiExpression value = returnStatement.getReturnValue();
            if (value == null) {
                return null;
            }
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)loopStatement);
            if (nextReturnStatement == null) {
                return null;
            }
            PsiExpression orElseExpression = nextReturnStatement.getReturnValue();
            if (!ExpressionUtils.isSimpleExpression(orElseExpression)) {
                return null;
            }
            String stream = FindFirstMigration.generateOptionalUnwrap(tb, value, orElseExpression, PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement));
            FindFirstMigration.restoreComments(loopStatement, body);
            boolean sibling = nextReturnStatement.getParent() == loopStatement.getParent();
            PsiElement replacement = loopStatement.replace((PsiElement)elementFactory.createStatementFromText("return " + stream + ";", (PsiElement)loopStatement));
            if (sibling || !FindFirstMigration.isReachable(nextReturnStatement)) {
                nextReturnStatement.delete();
            }
            return replacement;
        }
        PsiStatement[] statements = tb.getStatements();
        if (statements.length != 2) {
            return null;
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
        if (assignment == null) {
            if (!(statements[0] instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
            FindFirstMigration.restoreComments(loopStatement, body);
            return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(tb.generate() + ".findFirst().ifPresent(" + LambdaUtil.createLambda((PsiVariable)tb.getVariable(), (PsiExpression)expression) + ");", (PsiElement)loopStatement));
        }
        PsiReferenceExpression lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (lValue == null) {
            return null;
        }
        PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)lValue.resolve(), PsiVariable.class);
        if (var == null) {
            return null;
        }
        PsiExpression value = assignment.getRExpression();
        if (value == null) {
            return null;
        }
        FindFirstMigration.restoreComments(loopStatement, body);
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(var, loopStatement);
        PsiExpression initializer = var.getInitializer();
        PsiReferenceExpression falseExpression = lValue;
        if (status != ControlFlowUtils.InitializerUsageStatus.UNKNOWN && (status != ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE || ExpressionUtils.isSimpleExpression(initializer))) {
            falseExpression = initializer;
        } else {
            PsiElement maybeAssignment = PsiTreeUtil.skipSiblingsBackward((PsiElement)loopStatement, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            PsiExpression prevRValue = ExpressionUtils.getAssignmentTo(maybeAssignment, var);
            if (prevRValue != null) {
                maybeAssignment.delete();
                falseExpression = prevRValue;
            }
        }
        String replacementText = FindFirstMigration.generateOptionalUnwrap(tb, value, (PsiExpression)falseExpression, var.getType());
        return FindFirstMigration.replaceInitializer(loopStatement, var, initializer, replacementText, status);
    }

    private static String generateOptionalUnwrap(TerminalBlock tb, PsiExpression trueExpression, PsiExpression falseExpression, PsiType targetType) {
        String qualifier = tb.generate() + ".findFirst()";
        return OptionalUtil.generateOptionalUnwrap(qualifier, tb.getVariable(), trueExpression, falseExpression, targetType, false);
    }
}

