/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionViewNavigationPanel;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionResultsViewUtil {
    static void releaseEditor(@Nullable Editor editor) {
        if (editor != null && !editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
    }

    @Nullable
    static Navigatable getNavigatableForInvalidNode(ProblemDescriptionNode node) {
        PsiFile containingFile;
        RefEntity element;
        for (element = node.getElement(); element != null && !element.isValid(); element = element.getOwner()) {
        }
        if (!(element instanceof RefElement)) {
            return null;
        }
        PsiElement containingElement = ((RefElement)element).getElement();
        if (!(containingElement instanceof NavigatablePsiElement) || !containingElement.isValid()) {
            return null;
        }
        int lineNumber = node.getLineNumber();
        if (lineNumber != -1 && (containingFile = containingElement.getContainingFile()) != null) {
            VirtualFile file2 = containingFile.getVirtualFile();
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document != null && document.getLineCount() > lineNumber) {
                return new OpenFileDescriptor(containingElement.getProject(), file2, lineNumber, 0);
            }
        }
        return (Navigatable)containingElement;
    }

    @NotNull
    static JLabel getNothingToShowTextLabel() {
        JLabel jLabel = InspectionResultsViewUtil.createLabelForText(InspectionViewNavigationPanel.getTitleText(false));
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsViewUtil", "getNothingToShowTextLabel"));
        }
        return jLabel;
    }

    @NotNull
    static JComponent getInvalidEntityLabel(@NotNull RefEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/intellij/codeInspection/ui/InspectionResultsViewUtil", "getInvalidEntityLabel"));
        }
        String name = entity.getName();
        JLabel jLabel = InspectionResultsViewUtil.createLabelForText("'" + name + "' is no longer valid.");
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsViewUtil", "getInvalidEntityLabel"));
        }
        return jLabel;
    }

    public static JComponent getPreviewIsNotAvailable(@NotNull RefEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entity", "com/intellij/codeInspection/ui/InspectionResultsViewUtil", "getPreviewIsNotAvailable"));
        }
        String name = entity.getQualifiedName();
        return InspectionResultsViewUtil.createLabelForText("Preview is not available for '" + name + "'.");
    }

    @NotNull
    static JComponent getApplyingFixLabel(@NotNull InspectionToolWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/ui/InspectionResultsViewUtil", "getApplyingFixLabel"));
        }
        JLabel jLabel = InspectionResultsViewUtil.createLabelForText("Applying quick fix for '" + wrapper.getDisplayName() + "'...");
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsViewUtil", "getApplyingFixLabel"));
        }
        return jLabel;
    }

    @NotNull
    static JLabel createLabelForText(String text) {
        JBLabel multipleSelectionLabel = new JBLabel(text);
        multipleSelectionLabel.setVerticalAlignment(1);
        multipleSelectionLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)16, (int)12, (int)0, (int)0));
        JBLabel jBLabel = multipleSelectionLabel;
        if (jBLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsViewUtil", "createLabelForText"));
        }
        return jBLabel;
    }
}

