/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.InspectionTreeHtmlWriter;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ExcludedInspectionTreeNodesManager;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExportHTMLAction
extends AnAction
implements DumbAware {
    private final InspectionResultsView myView;
    @NonNls
    private static final String PROBLEMS = "problems";
    @NonNls
    private static final String HTML = "HTML";
    @NonNls
    private static final String XML = "XML";

    public ExportHTMLAction(InspectionResultsView view) {
        super(InspectionsBundle.message((String)"inspection.action.export.html", (Object[])new Object[0]), null, AllIcons.Actions.Export);
        this.myView = view;
    }

    public void actionPerformed(AnActionEvent e) {
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ExportHTMLAction.this.exportHTML(Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML)));
            }
        });
        InspectionResultsView.showPopup(e, (JBPopup)popup);
    }

    private void exportHTML(boolean exportToHTML) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(this.myView.getProject(), exportToHTML);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myView.getProject());
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        String outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
        ApplicationManager.getApplication().invokeLater(() -> {
            Runnable exportRunnable = () -> ApplicationManager.getApplication().runReadAction(() -> {
                if (!exportToHTML) {
                    this.dump2xml(outputDirectoryName);
                } else {
                    try {
                        new InspectionTreeHtmlWriter(this.myView, outputDirectoryName);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                }
            });
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(exportRunnable, InspectionsBundle.message((String)(exportToHTML ? "inspection.generating.html.progress.title" : "inspection.generating.xml.progress.title"), (Object[])new Object[0]), true, this.myView.getProject())) {
                return;
            }
            if (exportToHTML && exportToHTMLSettings.OPEN_IN_BROWSER) {
                BrowserUtil.browse((File)new File(exportToHTMLSettings.OUTPUT_DIRECTORY, "index.html"));
            }
        });
    }

    private void dump2xml(String outputDirectoryName) {
        try {
            File outputDir = new File(outputDirectoryName);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new IOException("Cannot create '" + outputDir + "'");
            }
            InspectionTreeNode root = this.myView.getTree().getRoot();
            IOException[] ex = new IOException[1];
            THashSet visitedWrappers = new THashSet();
            TreeUtil.traverse((TreeNode)root, arg_0 -> this.lambda$dump2xml$4((Set)visitedWrappers, outputDirectoryName, ex, arg_0));
            if (ex[0] != null) {
                throw ex[0];
            }
            Element element = new Element("inspections");
            String profileName = this.myView.getCurrentProfileName();
            if (profileName != null) {
                element.setAttribute("profile", profileName);
            }
            JDOMUtil.write((Parent)element, (File)new File(outputDirectoryName, ".descriptions.xml"), (String)CodeStyleSettingsManager.getSettings(null).getLineSeparator());
        }
        catch (IOException e) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myView, (String)e.getMessage()));
        }
    }

    @NotNull
    private Set<InspectionToolWrapper> getWorkedTools(@NotNull InspectionNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/ui/actions/ExportHTMLAction", "getWorkedTools"));
        }
        HashSet<InspectionToolWrapper> result2 = new HashSet<InspectionToolWrapper>();
        InspectionToolWrapper wrapper = node.getToolWrapper();
        if (this.myView.getCurrentProfileName() == null) {
            result2.add(wrapper);
            HashSet<InspectionToolWrapper> hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/ExportHTMLAction", "getWorkedTools"));
            }
            return hashSet;
        }
        String shortName = wrapper.getShortName();
        GlobalInspectionContextImpl context = this.myView.getGlobalInspectionContext();
        Tools tools = context.getTools().get(shortName);
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                result2.add(toolWrapper);
            }
        }
        HashSet<InspectionToolWrapper> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/actions/ExportHTMLAction", "getWorkedTools"));
        }
        return hashSet;
    }

    private /* synthetic */ boolean lambda$dump2xml$4(Set visitedWrappers, String outputDirectoryName, IOException[] ex, Object node) {
        if (node instanceof InspectionNode) {
            InspectionNode toolNode = (InspectionNode)node;
            Element problems = new Element(PROBLEMS);
            InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
            if (!visitedWrappers.add(toolWrapper)) {
                return true;
            }
            Set<InspectionToolWrapper> toolWrappers = this.getWorkedTools(toolNode);
            for (InspectionToolWrapper wrapper : toolWrappers) {
                InspectionToolPresentation presentation = this.myView.getGlobalInspectionContext().getPresentation(wrapper);
                ExcludedInspectionTreeNodesManager excludedManager = this.myView.getExcludedManager();
                if (toolNode.isExcluded(excludedManager)) continue;
                presentation.exportResults(problems, e -> excludedManager.containsRefEntity((RefEntity)e, toolWrapper), excludedManager::containsProblemDescriptor);
            }
            PathMacroManager.getInstance((ComponentManager)this.myView.getProject()).collapsePaths(problems);
            try {
                if (problems.getContentSize() != 0) {
                    JDOMUtil.writeDocument((Document)new Document(problems), (String)(outputDirectoryName + File.separator + toolWrapper.getShortName() + ".xml"), (String)CodeStyleSettingsManager.getSettings(null).getLineSeparator());
                }
            }
            catch (IOException e2) {
                ex[0] = e2;
            }
        }
        return true;
    }
}

