/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpecialAnnotationsUtilBase {
    public static LocalQuickFix createAddToSpecialAnnotationsListQuickFix(final @NotNull String text, final @NotNull String family, final @NotNull List<String> targetList, final @NotNull String qualifiedName, PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        if (targetList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetList", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = family;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "applyFix"));
                }
                SpecialAnnotationsUtilBase.doQuickFixInternal(project2, targetList, qualifiedName);
            }
        };
    }

    static void doQuickFixInternal(@NotNull Project project2, @NotNull List<String> targetList, @NotNull String qualifiedName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "doQuickFixInternal"));
        }
        if (targetList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetList", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "doQuickFixInternal"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "doQuickFixInternal"));
        }
        targetList.add(qualifiedName);
        Collections.sort(targetList);
        ProjectInspectionProfileManager.getInstance(project2).fireProfileChanged();
    }

    public static void createAddToSpecialAnnotationFixes(@NotNull PsiModifierListOwner owner, @NotNull Processor<String> processor2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationFixes"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationFixes"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            PsiAnnotation psiAnnotation;
            String name;
            PsiAnnotation[] psiAnnotations;
            PsiAnnotation[] psiAnnotationArray = psiAnnotations = modifierList.getAnnotations();
            int n = psiAnnotationArray.length;
            for (int j = 0; j < n && ((name = (psiAnnotation = psiAnnotationArray[j]).getQualifiedName()) == null || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.jetbrains.") && AnnotationUtil.isJetbrainsAnnotation((String)StringUtil.getShortName((String)name)) || processor2.process((Object)name)); ++j) {
            }
        }
    }
}

