/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentEnumeratorBase;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;

public class CompilerReferenceServiceImpl
extends CompilerReferenceService
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceServiceImpl.class);
    private final Set<FileType> myFileTypes;
    private final DirtyScopeHolder myDirtyScopeHolder;
    private final ProjectFileIndex myProjectFileIndex;
    private final LongAdder myCompilationCount = new LongAdder();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final Lock myReadDataLock = this.myLock.readLock();
    private final Lock myOpenCloseLock = this.myLock.writeLock();
    private volatile CompilerReferenceReader myReader;

    public CompilerReferenceServiceImpl(Project project2, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager) {
        super(project2);
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.myFileTypes = Stream.of(LanguageLightRefAdapter.INSTANCES).flatMap(a -> a.getFileTypes().stream()).collect(Collectors.toSet());
        this.myDirtyScopeHolder = new DirtyScopeHolder(this, fileDocumentManager, psiDocumentManager);
    }

    public void projectOpened() {
        if (CompilerReferenceServiceImpl.isEnabled()) {
            this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(BuildManagerListener.TOPIC, (Object)new BuildManagerListener(){

                @Override
                public void buildStarted(Project project2, UUID sessionId, boolean isAutomake) {
                    if (project2 == CompilerReferenceServiceImpl.this.myProject) {
                        CompilerReferenceServiceImpl.this.myDirtyScopeHolder.compilerActivityStarted();
                        CompilerReferenceServiceImpl.this.closeReaderIfNeed(false);
                    }
                }
            });
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            compilerManager.addCompilationStatusListener(new CompilationStatusListener(){

                public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    this.compilationFinished(compileContext);
                }

                public void automakeCompilationFinished(int errors, int warnings, CompileContext compileContext) {
                    this.compilationFinished(compileContext);
                }

                private void compilationFinished(CompileContext context) {
                    if (context.getProject() == CompilerReferenceServiceImpl.this.myProject) {
                        Runnable compilationFinished = () -> {
                            Module[] compilationModules = (Module[])ReadAction.compute(() -> {
                                if (CompilerReferenceServiceImpl.this.myProject.isDisposed()) {
                                    return null;
                                }
                                return context.getCompileScope().getAffectedModules();
                            });
                            if (compilationModules == null) {
                                return;
                            }
                            CompilerReferenceServiceImpl.this.myDirtyScopeHolder.compilerActivityFinished();
                            CompilerReferenceServiceImpl.this.myCompilationCount.increment();
                            CompilerReferenceServiceImpl.this.openReaderIfNeed();
                        };
                        CompilerReferenceServiceImpl.executeOnBuildThread(compilationFinished);
                    }
                }
            });
            this.myDirtyScopeHolder.installVFSListener();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean isUpToDate;
                    if (CompilerReferenceReader.exists(this.myProject)) {
                        CompileScope projectCompileScope = compilerManager.createProjectCompileScope(this.myProject);
                        isUpToDate = compilerManager.isUpToDate(projectCompileScope);
                    } else {
                        isUpToDate = false;
                    }
                    CompilerReferenceServiceImpl.executeOnBuildThread(() -> {
                        this.myDirtyScopeHolder.upToDateChecked(isUpToDate);
                        if (isUpToDate) {
                            this.myCompilationCount.increment();
                            this.openReaderIfNeed();
                        }
                    });
                });
            }
        }
    }

    public void projectClosed() {
        this.closeReaderIfNeed(false);
    }

    @Override
    @Nullable
    public GlobalSearchScope getScopeWithoutCodeReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getScopeWithoutCodeReferences"));
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getScopeWithoutCodeReferences$3"));
                }
                return CachedValueProvider.Result.create((Object)this.calculateScopeWithoutReferences(element), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            });
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return (GlobalSearchScope)this.onException(e, "scope without code references");
        }
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        return this.getHierarchyInfo(aClass, useScope, searchScope, searchFileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement functionalInterface, @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (functionalInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionalInterface", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        return this.getHierarchyInfo(functionalInterface, useScope, searchScope, searchFileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Nullable
    private CompilerHierarchyInfoImpl getHierarchyInfo(final @NotNull PsiNamedElement aClass, final @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (!this.isServiceEnabledFor((PsiElement)aClass) || searchScope == LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope()) {
            return null;
        }
        try {
            Map candidatesPerFile = (Map)ReadAction.compute(() -> {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$5"));
                }
                if (useScope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$5"));
                }
                if (searchType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$5"));
                }
                if (searchFileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$5"));
                }
                if (this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((Object)((Object)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
                    if (aClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$null$4"));
                    }
                    if (useScope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$null$4"));
                    }
                    return CachedValueProvider.Result.create((Object)new ConcurrentFactoryMap<HierarchySearchKey, Map<VirtualFile, Object[]>>(){

                        @Nullable
                        protected Map<VirtualFile, Object[]> create(HierarchySearchKey key2) {
                            return CompilerReferenceServiceImpl.this.calculateDirectInheritors(aClass, useScope, key2.mySearchFileType, key2.mySearchType);
                        }
                    }, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
                }))).get(new HierarchySearchKey(searchType, searchFileType));
            });
            if (candidatesPerFile == null) {
                return null;
            }
            GlobalSearchScope dirtyScope = this.myDirtyScopeHolder.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$6"));
                }
                return ElementPlace.get(aClass.getContainingFile().getVirtualFile(), this.myProjectFileIndex);
            })) {
                dirtyScope = dirtyScope.union((SearchScope)LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope());
            }
            return new CompilerHierarchyInfoImpl(candidatesPerFile, aClass, dirtyScope, searchScope, this.myProject, searchFileType, searchType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return (CompilerHierarchyInfoImpl)this.onException(e, "hierarchy");
        }
    }

    private boolean isServiceEnabledFor(PsiElement element) {
        if (!this.isServiceEnabled()) {
            return false;
        }
        PsiFile file2 = (PsiFile)ReadAction.compute(() -> element.getContainingFile());
        return file2 != null && !InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(file2);
    }

    private boolean isServiceEnabled() {
        return this.myReader != null && CompilerReferenceServiceImpl.isEnabled();
    }

    private Map<VirtualFile, Object[]> calculateDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope useScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements((PsiElement)aClass, false);
        if (searchElementInfo == null) {
            return null;
        }
        LightRef searchElement = searchElementInfo.searchElements[0];
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                Map<VirtualFile, Object[]> map = null;
                return map;
            }
            Map<VirtualFile, Object[]> map = this.myReader.getDirectInheritors(searchElement, useScope, this.myDirtyScopeHolder.getDirtyScope(), searchFileType, searchType);
            return map;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private GlobalSearchScope calculateScopeWithoutReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateScopeWithoutReferences"));
        }
        TIntHashSet referentFileIds = this.getReferentFileIds(element);
        if (referentFileIds == null) {
            return null;
        }
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)new ScopeWithoutReferencesOnCompilation(referentFileIds, this.myProjectFileIndex).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myDirtyScopeHolder.getDirtyScope())), (FileType[])this.myFileTypes.toArray(new FileType[this.myFileTypes.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TIntHashSet getReferentFileIds(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getReferentFileIds"));
        }
        CompilerElementInfo compilerElementInfo = this.asCompilerElements(element, true);
        if (compilerElementInfo == null) {
            return null;
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                TIntHashSet tIntHashSet = null;
                return tIntHashSet;
            }
            TIntHashSet referentFileIds = new TIntHashSet();
            for (TIntHashSet ref : compilerElementInfo.searchElements) {
                TIntHashSet referents;
                block12: {
                    try {
                        referents = this.myReader.findReferentFileIds((LightRef)ref, compilerElementInfo.place == ElementPlace.SRC);
                        if (referents != null) break block12;
                        TIntHashSet tIntHashSet = null;
                        return tIntHashSet;
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
                referentFileIds.addAll(referents.toArray());
            }
            TIntHashSet tIntHashSet = referentFileIds;
            return tIntHashSet;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerElementInfo asCompilerElements(@NotNull PsiElement psiElement, boolean buildHierarchyForLibraryElements) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "asCompilerElements"));
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (file2 == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace place = ElementPlace.get(file2, this.myProjectFileIndex);
            if (place == null || place == ElementPlace.SRC && this.myDirtyScopeHolder.contains(file2)) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageLightRefAdapter adapter = CompilerReferenceServiceImpl.findAdapterForFileType(file2.getFileType());
            if (adapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LightRef ref = adapter.asLightUsage(psiElement, this.myReader.getNameEnumerator());
            if (ref == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (place == ElementPlace.LIB && buildHierarchyForLibraryElements) {
                List<LightRef> elements = adapter.getHierarchyRestrictedToLibraryScope(ref, psiElement, this.myReader.getNameEnumerator(), LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope());
                LightRef[] fullHierarchy = new LightRef[elements.size() + 1];
                fullHierarchy[0] = ref;
                int i2 = 1;
                for (LightRef element : elements) {
                    fullHierarchy[i2++] = element;
                }
                CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, fullHierarchy);
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, new LightRef[]{ref});
            return compilerElementInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    private void closeReaderIfNeed(boolean removeIndex) {
        this.myOpenCloseLock.lock();
        try {
            if (this.myReader != null) {
                this.myReader.close(removeIndex);
                this.myReader = null;
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    private void openReaderIfNeed() {
        this.myOpenCloseLock.lock();
        try {
            if (this.myProject.isOpen()) {
                this.myReader = CompilerReferenceReader.create(this.myProject);
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    ProjectFileIndex getFileIndex() {
        return this.myProjectFileIndex;
    }

    Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    Project getProject() {
        return this.myProject;
    }

    @Nullable
    static LanguageLightRefAdapter findAdapterForFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "findAdapterForFileType"));
        }
        for (LanguageLightRefAdapter adapter : LanguageLightRefAdapter.INSTANCES) {
            if (!adapter.getFileTypes().contains(fileType)) continue;
            return adapter;
        }
        return null;
    }

    private static void executeOnBuildThread(Runnable compilationFinished) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            compilationFinished.run();
        } else {
            BuildManager.getInstance().runCommand(compilationFinished);
        }
    }

    public long getModificationCount() {
        return this.myCompilationCount.longValue();
    }

    @Nullable
    public Set<VirtualFile> getReferentFiles(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getReferentFiles"));
        }
        FileBasedIndex fileIndex = FileBasedIndex.getInstance();
        TIntHashSet ids = this.getReferentFileIds(element);
        if (ids == null) {
            return null;
        }
        THashSet fileSet = new THashSet();
        ids.forEach(arg_0 -> this.lambda$getReferentFiles$8(fileIndex, (Set)fileSet, arg_0));
        return fileSet;
    }

    @NotNull
    public DirtyScopeHolder getDirtyScopeHolder() {
        DirtyScopeHolder dirtyScopeHolder = this.myDirtyScopeHolder;
        if (dirtyScopeHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirtyScopeHolder"));
        }
        return dirtyScopeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFindUsages"));
        }
        this.myReadDataLock.lock();
        TIntHashSet referentFileIds = this.getReferentFileIds(element);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(referentFileIds, dirtyScopeInfo, this.myProject);
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo2 = compilerReferenceFindUsagesTestInfo;
        if (compilerReferenceFindUsagesTestInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFindUsages"));
        }
        return compilerReferenceFindUsagesTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        this.myReadDataLock.lock();
        CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, scope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        this.myReadDataLock.lock();
        CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, scope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private <T> T onException(@NotNull RuntimeException e, @NotNull String actionName) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "onException"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "onException"));
        }
        Throwable cause = e.getCause();
        if (cause instanceof PersistentEnumeratorBase.CorruptedException || cause instanceof StorageException) {
            this.closeReaderIfNeed(true);
        }
        LOG.error("an exception during " + actionName + " calculation", (Throwable)e);
        return null;
    }

    private /* synthetic */ boolean lambda$getReferentFiles$8(FileBasedIndex fileIndex, Set fileSet, int id) {
        VirtualFile vFile = fileIndex.findFileById(this.myProject, id);
        assert (vFile != null);
        fileSet.add(vFile);
        return true;
    }

    private static class HierarchySearchKey {
        private final CompilerHierarchySearchType mySearchType;
        private final FileType mySearchFileType;

        HierarchySearchKey(CompilerHierarchySearchType searchType, FileType searchFileType) {
            this.mySearchType = searchType;
            this.mySearchFileType = searchFileType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierarchySearchKey key2 = (HierarchySearchKey)o;
            return this.mySearchType == key2.mySearchType && this.mySearchFileType == key2.mySearchFileType;
        }

        public int hashCode() {
            return 31 * this.mySearchType.hashCode() + this.mySearchFileType.hashCode();
        }
    }

    static class CompilerElementInfo {
        final ElementPlace place;
        final LightRef[] searchElements;

        private CompilerElementInfo(ElementPlace place, LightRef ... searchElements) {
            this.place = place;
            this.searchElements = searchElements;
        }
    }

    private static class ScopeWithoutReferencesOnCompilation
    extends GlobalSearchScope {
        private final TIntHashSet myReferentIds;
        private final ProjectFileIndex myIndex;

        private ScopeWithoutReferencesOnCompilation(TIntHashSet ids, ProjectFileIndex index) {
            this.myReferentIds = ids;
            this.myIndex = index;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "contains"));
            }
            return file2 instanceof VirtualFileWithId && this.myIndex.isInSourceContent(file2) && !this.myReferentIds.contains(((VirtualFileWithId)file2).getId());
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "isSearchInModuleContent"));
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private static enum ElementPlace {
        SRC,
        LIB;


        private static ElementPlace get(VirtualFile file2, ProjectFileIndex index) {
            if (file2 == null) {
                return null;
            }
            return index.isInSourceContent(file2) ? SRC : (index.isInLibrarySource(file2) || index.isInLibraryClasses(file2) ? LIB : null);
        }
    }
}

