/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.JavaCompilerElementRetriever;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public class JavaLightUsageAdapter
implements LanguageLightRefAdapter {
    @Override
    @NotNull
    public Set<FileType> getFileTypes() {
        Set set2 = ContainerUtil.set((Object[])new FileType[]{JavaFileType.INSTANCE, JavaClassFileType.INSTANCE});
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getFileTypes"));
        }
        return set2;
    }

    @Override
    public LightRef asLightUsage(@NotNull PsiElement element, @NotNull NameEnumerator names) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "asLightUsage"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "asLightUsage"));
        }
        if (JavaLightUsageAdapter.mayBeVisibleOutsideOwnerFile(element)) {
            int nameId;
            String jvmClassName;
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                String name = field.getName();
                if (name == null || jvmOwnerName == null) {
                    return null;
                }
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                if (ownerId == 0) {
                    return null;
                }
                int nameId2 = names.tryEnumerate((Object)name);
                if (nameId2 == 0) {
                    return null;
                }
                return new LightRef.JavaLightFieldRef(ownerId, nameId2);
            }
            if (element instanceof PsiMethod) {
                PsiClass aClass = ((PsiMethod)element).getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                if (jvmOwnerName == null) {
                    return null;
                }
                PsiMethod method2 = (PsiMethod)element;
                String name = method2.isConstructor() ? "<init>" : method2.getName();
                int parametersCount = method2.getParameterList().getParametersCount();
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                if (ownerId == 0) {
                    return null;
                }
                int nameId3 = names.tryEnumerate((Object)name);
                if (nameId3 == 0) {
                    return null;
                }
                return new LightRef.JavaLightMethodRef(ownerId, nameId3, parametersCount);
            }
            if (element instanceof PsiClass && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null && (nameId = names.tryEnumerate((Object)jvmClassName)) != 0) {
                return new LightRef.JavaLightClassRef(nameId);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<LightRef> getHierarchyRestrictedToLibraryScope(@NotNull LightRef baseRef, @NotNull PsiElement basePsi, @NotNull NameEnumerator names, @NotNull GlobalSearchScope libraryScope) throws IOException {
        if (baseRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRef", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getHierarchyRestrictedToLibraryScope"));
        }
        if (basePsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePsi", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getHierarchyRestrictedToLibraryScope"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getHierarchyRestrictedToLibraryScope"));
        }
        if (libraryScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryScope", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getHierarchyRestrictedToLibraryScope"));
        }
        PsiClass baseClass = (PsiClass)ObjectUtils.notNull((Object)(basePsi instanceof PsiClass ? (PsiClass)basePsi : ((PsiMember)ReadAction.compute(() -> {
            if (basePsi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePsi", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "lambda$getHierarchyRestrictedToLibraryScope$0"));
            }
            return (PsiMember)basePsi;
        })).getContainingClass()));
        ArrayList<LightRef> overridden = new ArrayList<LightRef>();
        IOException[] exception = new IOException[]{null};
        Processor processor2 = c -> {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "lambda$getHierarchyRestrictedToLibraryScope$2"));
            }
            if (baseRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseRef", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "lambda$getHierarchyRestrictedToLibraryScope$2"));
            }
            if (c.hasModifierProperty("private")) {
                return true;
            }
            String qName = (String)ReadAction.compute(() -> c.getQualifiedName());
            if (qName == null) {
                return true;
            }
            try {
                int nameId = names.tryEnumerate((Object)qName);
                if (nameId != 0) {
                    overridden.add(baseRef.override(nameId));
                }
            }
            catch (IOException e) {
                exception[0] = e;
                return false;
            }
            return true;
        };
        if (exception[0] != null) {
            throw exception[0];
        }
        ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)LibraryScopeCache.getInstance(baseClass.getProject()).getLibrariesOnlyScope(), (boolean)true).forEach(processor2);
        ArrayList<LightRef> arrayList = overridden;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getHierarchyRestrictedToLibraryScope"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Class<? extends LightRef.LightClassHierarchyElementDef> getHierarchyObjectClass() {
        if (LightRef.JavaLightClassRef.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getHierarchyObjectClass"));
        }
        return LightRef.JavaLightClassRef.class;
    }

    @Override
    @NotNull
    public Class<? extends LightRef> getFunExprClass() {
        if (LightRef.JavaLightFunExprDef.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "getFunExprClass"));
        }
        return LightRef.JavaLightFunExprDef.class;
    }

    @NotNull
    public PsiClass[] findDirectInheritorCandidatesInFile(@NotNull String[] internalNames, @NotNull PsiFileWithStubSupport file2, @NotNull PsiNamedElement superClass) {
        if (internalNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalNames", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "findDirectInheritorCandidatesInFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "findDirectInheritorCandidatesInFile"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "findDirectInheritorCandidatesInFile"));
        }
        PsiClass[] psiClassArray = JavaCompilerElementRetriever.retrieveClassesByInternalNames(internalNames, superClass, file2);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "findDirectInheritorCandidatesInFile"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiFunctionalExpression[] findFunExpressionsInFile(@NotNull Integer[] funExpressions, @NotNull PsiFileWithStubSupport file2) {
        if (funExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funExpressions", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "findFunExpressionsInFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "findFunExpressionsInFile"));
        }
        TIntHashSet requiredIndices = new TIntHashSet(funExpressions.length);
        Integer[] integerArray = funExpressions;
        int n = integerArray.length;
        for (int j = 0; j < n; ++j) {
            int funExpr = integerArray[j];
            requiredIndices.add(funExpr);
        }
        PsiFunctionalExpression[] psiFunctionalExpressionArray = JavaCompilerElementRetriever.retrieveFunExpressionsByIndices(requiredIndices, file2);
        if (psiFunctionalExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "findFunExpressionsInFile"));
        }
        return psiFunctionalExpressionArray;
    }

    @Override
    public boolean isDirectInheritor(PsiElement candidate, PsiNamedElement baseClass) {
        return ((PsiClass)candidate).isInheritor((PsiClass)baseClass, false);
    }

    private static boolean mayBeVisibleOutsideOwnerFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/JavaLightUsageAdapter", "mayBeVisibleOutsideOwnerFile"));
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return true;
        }
        return !((PsiModifierListOwner)element).hasModifierProperty("private");
    }
}

