/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntHashSet;
import java.util.stream.IntStream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerReferenceFindUsagesTestInfo {
    @Nullable
    private final TIntHashSet myFileIds;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;
    @NotNull
    private final Project myProject;

    public CompilerReferenceFindUsagesTestInfo(@Nullable TIntHashSet occurrencesIds, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo, @NotNull Project project2) {
        if (dirtyScopeTestInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyScopeTestInfo", "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo", "<init>"));
        }
        this.myFileIds = occurrencesIds;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
        this.myProject = project2;
    }

    @NotNull
    VirtualFile[] getFilesWithKnownOccurrences() {
        if (this.myFileIds == null) {
            throw new IllegalStateException();
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        VirtualFile[] virtualFileArray = (VirtualFile[])IntStream.of(this.myFileIds.toArray()).mapToObj(id -> fileBasedIndex.findFileById(this.myProject, id)).filter(f -> !this.myDirtyScopeInfo.getDirtyScope().contains(f)).toArray(VirtualFile[]::new);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo", "getFilesWithKnownOccurrences"));
        }
        return virtualFileArray;
    }

    @NotNull
    Module[] getDirtyModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo", "getDirtyModules"));
        }
        return moduleArray;
    }

    @NotNull
    Module[] getDirtyUnsavedModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyUnsavedModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo", "getDirtyUnsavedModules"));
        }
        return moduleArray;
    }

    @NotNull
    VirtualFile[] getExcludedFiles() {
        VirtualFile[] virtualFileArray = this.myDirtyScopeInfo.getExcludedFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceFindUsagesTestInfo", "getExcludedFiles"));
        }
        return virtualFileArray;
    }

    boolean isEnabled() {
        return this.myFileIds != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known occurrence files");
            node.add(knownOccurrences);
            for (VirtualFile file2 : this.getFilesWithKnownOccurrences()) {
                knownOccurrences.add(new DefaultMutableTreeNode(file2));
            }
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module2 : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module2));
            }
            DefaultMutableTreeNode unsavedDirtyModules = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(unsavedDirtyModules);
            for (Module module3 : this.getDirtyUnsavedModules()) {
                unsavedDirtyModules.add(new DefaultMutableTreeNode(module3));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }
}

