/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs.view;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerReferenceHierarchyTestInfo {
    @Nullable
    private final CompilerDirectHierarchyInfo myHierarchyInfo;
    @NotNull
    private final DirtyScopeTestInfo myDirtyScopeInfo;

    public CompilerReferenceHierarchyTestInfo(@Nullable CompilerDirectHierarchyInfo hierarchyInfo, @NotNull DirtyScopeTestInfo dirtyScopeTestInfo) {
        if (dirtyScopeTestInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtyScopeTestInfo", "com/intellij/compiler/backwardRefs/view/CompilerReferenceHierarchyTestInfo", "<init>"));
        }
        this.myHierarchyInfo = hierarchyInfo;
        this.myDirtyScopeInfo = dirtyScopeTestInfo;
    }

    @NotNull
    public Stream<PsiElement> getHierarchyChildren() {
        if (this.myHierarchyInfo == null) {
            throw new IllegalArgumentException();
        }
        Stream<PsiElement> stream = this.myHierarchyInfo.getHierarchyChildren();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceHierarchyTestInfo", "getHierarchyChildren"));
        }
        return stream;
    }

    @NotNull
    Module[] getDirtyModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceHierarchyTestInfo", "getDirtyModules"));
        }
        return moduleArray;
    }

    @NotNull
    Module[] getDirtyUnsavedModules() {
        Module[] moduleArray = this.myDirtyScopeInfo.getDirtyUnsavedModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceHierarchyTestInfo", "getDirtyUnsavedModules"));
        }
        return moduleArray;
    }

    @NotNull
    VirtualFile[] getExcludedFiles() {
        VirtualFile[] virtualFileArray = this.myDirtyScopeInfo.getExcludedFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/view/CompilerReferenceHierarchyTestInfo", "getExcludedFiles"));
        }
        return virtualFileArray;
    }

    boolean isEnabled() {
        return this.myHierarchyInfo != null;
    }

    DefaultMutableTreeNode asTree() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        if (this.isEnabled()) {
            DefaultMutableTreeNode knownOccurrences = new DefaultMutableTreeNode("Known hierarchy direct children");
            node.add(knownOccurrences);
            this.getHierarchyChildren().forEach(e -> knownOccurrences.add(new DefaultMutableTreeNode(e)));
            DefaultMutableTreeNode dirtyModules = new DefaultMutableTreeNode("Dirty modules");
            node.add(dirtyModules);
            for (Module module2 : this.getDirtyModules()) {
                dirtyModules.add(new DefaultMutableTreeNode(module2));
            }
            DefaultMutableTreeNode unsavedDirtyModules = new DefaultMutableTreeNode("Unsaved dirty modules");
            node.add(unsavedDirtyModules);
            for (Module module3 : this.getDirtyUnsavedModules()) {
                unsavedDirtyModules.add(new DefaultMutableTreeNode(module3));
            }
            DefaultMutableTreeNode excludedFiles = new DefaultMutableTreeNode("Current excluded files");
            node.add(excludedFiles);
            for (VirtualFile excludedFile : this.getExcludedFiles()) {
                excludedFiles.add(new DefaultMutableTreeNode(excludedFile));
            }
        } else {
            node.add(new DefaultMutableTreeNode("Service is not available"));
        }
        return node;
    }
}

