/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.compiler.classFilesIndex.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodsChain;
import com.intellij.compiler.classFilesIndex.chainsSearch.WeightAware;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.classFilesIndex.impl.MethodIncompleteSignature;
import com.intellij.compiler.classFilesIndex.impl.UsageIndexValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class SearchInitializer {
    private static final int CHAIN_SEARCH_MAGIC_RATIO = 12;
    private final LinkedHashMap<MethodIncompleteSignature, Pair<MethodsChain, Integer>> myChains;
    private final ChainCompletionContext myContext;

    public SearchInitializer(SortedSet<UsageIndexValue> indexValues, String targetQName, Set<String> excludedParamsTypesQNames, ChainCompletionContext context) {
        this.myContext = context;
        int size = indexValues.size();
        this.myChains = new LinkedHashMap(size);
        this.add(indexValues, MethodChainsSearchUtil.joinToHashSet(excludedParamsTypesQNames, targetQName));
    }

    private void add(Collection<UsageIndexValue> indexValues, Set<String> excludedParamsTypesQNames) {
        int bestOccurrences = -1;
        for (UsageIndexValue indexValue : indexValues) {
            if (!this.add(indexValue, excludedParamsTypesQNames)) continue;
            int occurrences = indexValue.getOccurrences();
            if (bestOccurrences == -1) {
                bestOccurrences = occurrences;
                continue;
            }
            if (bestOccurrences <= occurrences * 12) continue;
            return;
        }
    }

    private boolean add(UsageIndexValue indexValue, Set<String> excludedParamsTypesQNames) {
        MethodIncompleteSignature methodInvocation = indexValue.getMethodIncompleteSignature();
        PsiMethod[] psiMethods = this.myContext.resolveNotDeprecated(methodInvocation);
        if (psiMethods.length != 0 && MethodChainsSearchUtil.checkParametersForTypesQNames(psiMethods, excludedParamsTypesQNames)) {
            int occurrences = indexValue.getOccurrences();
            MethodsChain methodsChain = new MethodsChain(psiMethods, occurrences, indexValue.getMethodIncompleteSignature().getOwner());
            this.myChains.put(methodInvocation, (Pair<MethodsChain, Integer>)Pair.create((Object)methodsChain, (Object)occurrences));
            return true;
        }
        return false;
    }

    public InitResult init(Set<String> excludedEdgeNames) {
        int size = this.myChains.size();
        ArrayList<WeightAware<MethodIncompleteSignature>> initedVertexes = new ArrayList<WeightAware<MethodIncompleteSignature>>(size);
        LinkedHashMap<MethodIncompleteSignature, MethodsChain> initedChains = new LinkedHashMap<MethodIncompleteSignature, MethodsChain>(size);
        for (Map.Entry<MethodIncompleteSignature, Pair<MethodsChain, Integer>> entry : this.myChains.entrySet()) {
            MethodIncompleteSignature signature = entry.getKey();
            if (excludedEdgeNames.contains(signature.getName())) continue;
            initedVertexes.add(new WeightAware<MethodIncompleteSignature>(entry.getKey(), (Integer)entry.getValue().getSecond()));
            MethodsChain methodsChain = (MethodsChain)entry.getValue().getFirst();
            initedChains.put(signature, methodsChain);
        }
        return new InitResult(initedVertexes, initedChains);
    }

    public static class InitResult {
        private final List<WeightAware<MethodIncompleteSignature>> myVertexes;
        private final LinkedHashMap<MethodIncompleteSignature, MethodsChain> myChains;

        private InitResult(List<WeightAware<MethodIncompleteSignature>> vertexes, LinkedHashMap<MethodIncompleteSignature, MethodsChain> chains) {
            this.myVertexes = vertexes;
            this.myChains = chains;
        }

        public List<WeightAware<MethodIncompleteSignature>> getVertexes() {
            return this.myVertexes;
        }

        public LinkedHashMap<MethodIncompleteSignature, MethodsChain> getChains() {
            return this.myChains;
        }
    }
}

