/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.ChainCompletionLookupElementUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.completion.lookup.sub.SubLookupElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainCompletionMethodCallLookupElement
extends JavaMethodCallElement
implements StaticallyImportable {
    public static final String PROP_METHODS_CHAIN_COMPLETION_AUTO_COMPLETION = "methods.chain.completion.autoCompletion";
    private final PsiMethod myMethod;
    @Nullable
    private final TIntObjectHashMap<SubLookupElement> myReplaceElements;
    private final boolean myMergedOverloads;

    public ChainCompletionMethodCallLookupElement(PsiMethod method2, @Nullable TIntObjectHashMap<SubLookupElement> replaceElements, boolean shouldImportStatic, boolean mergedOverloads) {
        super(method2, shouldImportStatic, mergedOverloads);
        this.myMethod = method2;
        this.myReplaceElements = replaceElements;
        this.myMergedOverloads = mergedOverloads;
        this.configureAutoCompletionPolicy();
    }

    public ChainCompletionMethodCallLookupElement(PsiMethod method2, @Nullable TIntObjectHashMap<SubLookupElement> replaceElements) {
        super(method2);
        this.myMethod = method2;
        this.myReplaceElements = replaceElements;
        this.myMergedOverloads = true;
        this.configureAutoCompletionPolicy();
    }

    private void configureAutoCompletionPolicy() {
        if (ApplicationManager.getApplication().isUnitTestMode() && PropertiesComponent.getInstance((Project)this.myMethod.getProject()).getBoolean(PROP_METHODS_CHAIN_COMPLETION_AUTO_COMPLETION)) {
            this.setAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE);
        }
    }

    @Override
    public void handleInsert(InsertionContext context) {
        super.handleInsert(context);
        if (!this.myMergedOverloads || ChainCompletionMethodCallLookupElement.isUniqueMethod(this.myMethod)) {
            context.commitDocument();
            context.getDocument().insertString(context.getTailOffset() - 1, (CharSequence)ChainCompletionLookupElementUtil.fillMethodParameters(this.myMethod, this.myReplaceElements));
            PsiFile file2 = context.getFile();
            assert (file2 instanceof PsiJavaFile);
            final PsiJavaFile javaFile = (PsiJavaFile)file2;
            if (this.myReplaceElements != null) {
                this.myReplaceElements.forEachValue((TObjectProcedure)new TObjectProcedure<SubLookupElement>(){

                    public boolean execute(SubLookupElement subLookupElement) {
                        subLookupElement.doImport(javaFile);
                        return true;
                    }
                });
            }
            context.commitDocument();
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
            context.commitDocument();
        }
    }

    private static boolean isUniqueMethod(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/compiler/classFilesIndex/chainsSearch/completion/lookup/ChainCompletionMethodCallLookupElement", "isUniqueMethod"));
        }
        PsiClass containingClass = method2.getContainingClass();
        return containingClass == null || containingClass.findMethodsByName(method2.getName(), true).length == 1;
    }
}

