/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.GenericCompilerRunner;
import com.intellij.compiler.impl.generic.GenericCompilerCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityStateFactory;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CompilerCacheManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerCacheManager");
    private final Map<Compiler, Object> myCompilerToCacheMap = new HashMap<Compiler, Object>();
    private final Map<GenericCompiler<?, ?, ?>, GenericCompilerCache<?, ?, ?>> myGenericCachesMap = new HashMap();
    private final List<Disposable> myCacheDisposables = new ArrayList<Disposable>();
    private final File myCachesRoot;
    private final Project myProject;

    public CompilerCacheManager(Project project2) {
        this.myProject = project2;
        this.myCachesRoot = CompilerPaths.getCacheStoreDirectory((Project)project2);
    }

    public static CompilerCacheManager getInstance(Project project2) {
        return (CompilerCacheManager)project2.getComponent(CompilerCacheManager.class);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("CompilerCacheManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerCacheManager", "getComponentName"));
        }
        return "CompilerCacheManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.flushCaches();
    }

    private File getCompilerRootDir(Compiler compiler) {
        File dir = new File(this.myCachesRoot, CompilerCacheManager.getCompilerIdString(compiler));
        dir.mkdirs();
        return dir;
    }

    synchronized <Key, SourceState, OutputState> GenericCompilerCache<Key, SourceState, OutputState> getGenericCompilerCache(GenericCompiler<Key, SourceState, OutputState> compiler) throws IOException {
        GenericCompilerCache<Object, Object, Object> cache = this.myGenericCachesMap.get(compiler);
        if (cache == null) {
            GenericCompilerCache genericCache = new GenericCompilerCache(compiler, GenericCompilerRunner.getGenericCompilerCacheDir(this.myProject, compiler));
            this.myGenericCachesMap.put(compiler, genericCache);
            this.myCacheDisposables.add(() -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing cache for feneric compiler " + compiler.getId());
                }
                genericCache.close();
            });
            cache = genericCache;
        }
        return cache;
    }

    synchronized FileProcessingCompilerStateCache getFileProcessingCompilerCache(FileProcessingCompiler compiler) throws IOException {
        Object cache = this.myCompilerToCacheMap.get(compiler);
        if (cache == null) {
            File compilerRootDir = this.getCompilerRootDir((Compiler)compiler);
            FileProcessingCompilerStateCache stateCache = new FileProcessingCompilerStateCache(compilerRootDir, (ValidityStateFactory)compiler);
            this.myCompilerToCacheMap.put((Compiler)compiler, stateCache);
            this.myCacheDisposables.add(() -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing cache for compiler " + compiler.getDescription() + "; cache root dir: " + compilerRootDir);
                }
                stateCache.close();
            });
            cache = stateCache;
        } else {
            LOG.assertTrue(cache instanceof FileProcessingCompilerStateCache);
        }
        return (FileProcessingCompilerStateCache)cache;
    }

    public static String getCompilerIdString(Compiler compiler) {
        String description = compiler.getDescription();
        return description.replaceAll("\\s+", "_").replaceAll("[\\.\\?]", "_").toLowerCase();
    }

    synchronized void flushCaches() {
        for (Disposable disposable : this.myCacheDisposables) {
            try {
                Disposer.dispose((Disposable)disposable);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        this.myCacheDisposables.clear();
        this.myGenericCachesMap.clear();
        this.myCompilerToCacheMap.clear();
    }

    public void clearCaches(CompileContext context) {
        this.flushCaches();
        File[] children2 = this.myCachesRoot.listFiles();
        if (children2 != null) {
            for (File child : children2) {
                boolean deleteOk = FileUtil.delete((File)child);
                if (deleteOk) continue;
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.failed.to.delete", (Object[])new Object[]{child.getPath()}), null, -1, -1);
            }
        }
    }
}

