/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class ProcessedModulesTable
extends JPanel {
    private JBTable myTable = null;
    private MyTableModel myTableModel = null;
    private int[] mySavedSelection = null;

    public ProcessedModulesTable(Project project2) {
        super(new BorderLayout());
        this.myTableModel = new MyTableModel(project2);
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.getEmptyText().setText("No modules configured");
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn dirNameColumn = columnModel.getColumn(this.myTableModel.DIRNAME_COLUMN_INDEX);
        String title = "Generated Sources Directory Name";
        dirNameColumn.setHeaderValue("Generated Sources Directory Name");
        JTableHeader tableHeader = this.myTable.getTableHeader();
        FontMetrics metrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int preferredWidth = metrics.stringWidth("Generated Sources Directory Name") + 12;
        dirNameColumn.setPreferredWidth(preferredWidth);
        dirNameColumn.setMaxWidth(preferredWidth + 20);
        dirNameColumn.setCellRenderer(new MyElementColumnCellRenderer());
        TableColumn moduleColumn = columnModel.getColumn(this.myTableModel.ELEMENT_COLUMN_INDEX);
        moduleColumn.setHeaderValue("Module");
        moduleColumn.setCellRenderer(new MyElementColumnCellRenderer());
        JPanel panel2 = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpDownActions().setPreferredSize((Dimension)JBUI.size((int)100, (int)155)).createPanel();
        this.add((Component)panel2, "Center");
        SpeedSearchBase<JBTable> speedSearch = new SpeedSearchBase<JBTable>(this.myTable){

            @Override
            public int getSelectedIndex() {
                return ProcessedModulesTable.this.myTable.getSelectedRow();
            }

            @Override
            protected int convertIndexToModel(int viewIndex) {
                return ProcessedModulesTable.this.myTable.convertRowIndexToModel(viewIndex);
            }

            @Override
            public Object[] getAllElements() {
                int count = ProcessedModulesTable.this.myTableModel.getRowCount();
                Object[] elements = new Object[count];
                for (int idx = 0; idx < count; ++idx) {
                    elements[idx] = ProcessedModulesTable.this.myTableModel.getModuleAt(idx);
                }
                return elements;
            }

            @Override
            public String getElementText(Object element) {
                return ((Module)element).getName() + " (" + FileUtil.toSystemDependentName((String)((Module)element).getModuleFilePath()) + ")";
            }

            @Override
            public void selectElement(Object element, String selectedText) {
                int count = ProcessedModulesTable.this.myTableModel.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element.equals(ProcessedModulesTable.this.myTableModel.getModuleAt(row))) continue;
                    int viewRow = ProcessedModulesTable.this.myTable.convertRowIndexToView(row);
                    ProcessedModulesTable.this.myTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    TableUtil.scrollSelectionToVisible((JTable)ProcessedModulesTable.this.myTable);
                    break;
                }
            }
        };
        speedSearch.setComparator(new SpeedSearchComparator(false));
    }

    public void refresh() {
        this.myTableModel.fireTableDataChanged();
    }

    public void refresh(Module element) {
        int row = this.myTableModel.getElementRow(element);
        if (row >= 0) {
            this.myTableModel.fireTableRowsUpdated(row, row);
        }
    }

    public void saveSelection() {
        this.mySavedSelection = this.myTable.getSelectedRows();
    }

    public void restoreSelection() {
        if (this.mySavedSelection != null) {
            TableUtil.selectRows((JTable)this.myTable, (int[])this.mySavedSelection);
            this.mySavedSelection = null;
        }
    }

    public void addModule(Module element, String dirName) {
        this.myTableModel.addElement(element, dirName);
        this.selectRow(this.myTableModel.getRowCount() - 1);
        this.myTable.requestFocus();
    }

    public void removeModule(Module element) {
        int elementRow = this.myTableModel.getElementRow(element);
        if (elementRow < 0) {
            return;
        }
        boolean wasSelected = this.myTable.getSelectionModel().isSelectedIndex(elementRow);
        this.myTableModel.removeElement(element);
        if (wasSelected) {
            int rowCount = this.myTableModel.getRowCount();
            if (rowCount > 0) {
                this.selectRow(elementRow % rowCount);
            } else {
                this.myTable.getSelectionModel().clearSelection();
            }
        }
        this.myTable.requestFocus();
    }

    public void removeAllElements() {
        this.myTableModel.removeAllElements();
        this.myTable.getSelectionModel().clearSelection();
    }

    private void selectRow(int row) {
        this.myTable.getSelectionModel().setSelectionInterval(row, row);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
    }

    @Nullable
    public Module getSelectedElement() {
        int selectedRow = this.getSelectedElementRow();
        return selectedRow < 0 ? null : this.myTableModel.getModuleAt(selectedRow);
    }

    public int getSelectedElementRow() {
        return this.myTable.getSelectedRow();
    }

    public List<Module> getSelectedElements() {
        int[] selectedRows;
        ArrayList<Module> elements = new ArrayList<Module>();
        for (int selectedRow : selectedRows = this.myTable.getSelectedRows()) {
            if (selectedRow < 0) continue;
            elements.add(this.myTableModel.getModuleAt(selectedRow));
        }
        return elements;
    }

    public void selectElements(Collection<? extends Module> elements) {
        if (elements.size() == 0) {
            this.myTable.clearSelection();
            return;
        }
        int[] rows = this.getElementsRows(elements);
        TableUtil.selectRows((JTable)this.myTable, (int[])rows);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        this.myTable.requestFocus();
    }

    private int[] getElementsRows(Collection<? extends Module> elements) {
        int[] rows = new int[elements.size()];
        int index = 0;
        for (Module module2 : elements) {
            rows[index++] = this.myTableModel.getElementRow(module2);
        }
        return rows;
    }

    public List<Pair<Module, String>> getAllModules() {
        int count = this.myTableModel.getRowCount();
        ArrayList<Pair<Module, String>> elements = new ArrayList<Pair<Module, String>>();
        for (int idx = 0; idx < count; ++idx) {
            Module module2 = this.myTableModel.getModuleAt(idx);
            elements.add((Pair<Module, String>)Pair.create((Object)module2, (Object)this.myTableModel.getGenDirName(module2)));
        }
        return elements;
    }

    public void sort(Comparator<Module> comparator2) {
        this.myTableModel.sort(comparator2);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myTable.setRowSelectionAllowed(enabled);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public JComponent getComponent() {
        return this.myTable;
    }

    public void clear() {
        this.myTableModel.clear();
    }

    public int getElementCount() {
        return this.myTableModel.getRowCount();
    }

    public Module getElementAt(int row) {
        return this.myTableModel.getModuleAt(row);
    }

    private class MyElementColumnCellRenderer
    extends DefaultTableCellRenderer {
        private MyElementColumnCellRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component;
            Color color = UIUtil.getTableFocusCellBackground();
            Module module2 = value instanceof Module ? (Module)value : null;
            try {
                UIManager.put("Table.focusCellBackground", table.getSelectionBackground());
                component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (module2 != null) {
                    this.setText(module2.getName() + " (" + FileUtil.toSystemDependentName((String)module2.getModuleFilePath()) + ")");
                }
                if (component instanceof JLabel) {
                    ((JLabel)component).setBorder(noFocusBorder);
                }
            }
            finally {
                UIManager.put("Table.focusCellBackground", color);
            }
            component.setEnabled(ProcessedModulesTable.this.isEnabled());
            if (component instanceof JLabel) {
                Icon icon = module2 != null ? ModuleType.get((Module)module2).getIcon() : null;
                JLabel label = (JLabel)component;
                label.setIcon(icon);
                label.setDisabledIcon(icon);
            }
            component.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            return component;
        }
    }

    private final class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<Module> myElements = new ArrayList<Module>();
        private final Map<Module, String> myDirNameMap = new HashMap<Module, String>();
        public final int ELEMENT_COLUMN_INDEX = 0;
        public final int DIRNAME_COLUMN_INDEX = 1;
        private final Project myProject;

        private MyTableModel(Project project2) {
            this.myProject = project2;
        }

        public void sort(Comparator<Module> comparator2) {
            Collections.sort(this.myElements, comparator2);
            this.fireTableDataChanged();
        }

        public List<Module> getAllModules() {
            return Collections.unmodifiableList(this.myElements);
        }

        public Module getModuleAt(int index) {
            return this.myElements.get(index);
        }

        public String getGenDirName(Module module2) {
            return this.myDirNameMap.get(module2);
        }

        void addElement(Module module2, String dirName) {
            this.myElements.add(module2);
            if (dirName != null && dirName.length() > 0) {
                this.myDirNameMap.put(module2, dirName);
            }
            int row = this.myElements.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        public void addRow() {
            HashSet<Module> projectModules = new HashSet<Module>(Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()));
            projectModules.removeAll(this.getAllModules());
            ChooseModulesDialog chooser = new ChooseModulesDialog((Component)ProcessedModulesTable.this, (List<Module>)new ArrayList<Module>(projectModules), "ChooseModule");
            if (chooser.showAndGet()) {
                List chosen = chooser.getChosenElements();
                for (Module module2 : chosen) {
                    this.addElement(module2, null);
                }
            }
        }

        public void removeRow(int idx) {
            Module element = this.myElements.remove(idx);
            this.myDirNameMap.remove(element);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void removeElement(Module element) {
            boolean reallyRemoved = this.myElements.remove(element);
            if (reallyRemoved) {
                this.myDirNameMap.remove(element);
                this.fireTableDataChanged();
            }
        }

        public int getElementRow(Module element) {
            return this.myElements.indexOf(element);
        }

        public void removeAllElements() {
            this.myElements.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myElements.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            Module element = this.myElements.get(rowIndex);
            if (columnIndex == 0) {
                return element;
            }
            if (columnIndex == 1) {
                return this.myDirNameMap.get(element);
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                Module module2 = this.myElements.get(rowIndex);
                if (value != null) {
                    String dir = FileUtil.toSystemIndependentName((String)((String)value));
                    while (dir.startsWith("/")) {
                        dir = dir.substring(1);
                    }
                    if (dir.length() > 0) {
                        this.myDirNameMap.put(module2, dir);
                    } else {
                        this.myDirNameMap.remove(module2);
                    }
                } else {
                    this.myDirNameMap.remove(module2);
                }
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return String.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!ProcessedModulesTable.this.isEnabled()) {
                return false;
            }
            return columnIndex == 1;
        }

        public void clear() {
            this.myElements.clear();
            this.myDirNameMap.clear();
            this.fireTableDataChanged();
        }
    }
}

