/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DirectoryStorageUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0016J,\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\"\u001a\u00020\u0002H\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorageBase;", "Lcom/intellij/configurationStore/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "(Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;)V", "componentName", "", "getComponentName", "()Ljava/lang/String;", "setComponentName", "(Ljava/lang/String;)V", "getPathMacroSubstitutor", "()Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "getSplitter", "()Lcom/intellij/openapi/components/StateSplitter;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "analyzeExternalChangesAndUpdateIfNeed", "", "componentNames", "", "getSerializedState", "Lorg/jdom/Element;", "storageData", "component", "", "archive", "", "hasState", "loadData", "startExternalization", "Lcom/intellij/openapi/components/StateStorage$ExternalizationSession;", "configuration-store-impl"})
public abstract class DirectoryBasedStorageBase
extends StateStorageBase<StateMap> {
    @Nullable
    private String componentName;
    @NotNull
    private final StateSplitter splitter;
    @Nullable
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;

    @Nullable
    protected final String getComponentName() {
        return this.componentName;
    }

    protected final void setComponentName(@Nullable String string) {
        this.componentName = string;
    }

    @Nullable
    protected abstract VirtualFile getVirtualFile();

    @Override
    @NotNull
    protected StateMap loadData() {
        Map<String, Element> map = DirectoryStorageUtil.loadFrom(this.getVirtualFile(), this.pathMacroSubstitutor);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"DirectoryStorageUtil.loa\u2026le, pathMacroSubstitutor)");
        return StateMap.Companion.fromMap(map);
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return null;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        StateMap newData = this.loadData();
        this.getStorageDataRef().set(newData);
        if (this.componentName != null) {
            String string = this.componentName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            componentNames.add(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        if (storageData.isEmpty()) {
            return null;
        }
        Element state = new Element("component");
        if (this.splitter instanceof StateSplitterEx) {
            String[] stringArray = storageData.keys();
            for (int j = 0; j < stringArray.length; ++j) {
                Element subState;
                String fileName = stringArray[j];
                if (storageData.getState(fileName, archive) == null) {
                    return null;
                }
                ((StateSplitterEx)this.splitter).mergeStateInto(state, subState);
            }
        } else {
            Object fileName;
            SmartList subElements = new SmartList();
            String[] subState = storageData.keys();
            for (int j = 0; j < subState.length; ++j) {
                Element subState2;
                fileName = subState[j];
                if (storageData.getState((String)fileName, archive) == null) {
                    return null;
                }
                subElements.add((Object)subState2);
            }
            if (!subElements.isEmpty()) {
                void $receiver$iv;
                fileName = (Collection)subElements;
                Element element = state;
                StateSplitter stateSplitter = this.splitter;
                void thisCollection$iv = $receiver$iv;
                Element[] elementArray = thisCollection$iv.toArray(new Element[thisCollection$iv.size()]);
                if (elementArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Element[] elementArray2 = elementArray;
                stateSplitter.mergeStatesInto(element, elementArray2);
            }
        }
        return state;
    }

    @Override
    protected boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.hasStates();
    }

    @NotNull
    protected final StateSplitter getSplitter() {
        return this.splitter;
    }

    @Nullable
    protected final TrackingPathMacroSubstitutor getPathMacroSubstitutor() {
        return this.pathMacroSubstitutor;
    }

    public DirectoryBasedStorageBase(@NotNull StateSplitter splitter, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
        this.splitter = splitter;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
    }

    public /* synthetic */ DirectoryBasedStorageBase(StateSplitter stateSplitter, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        this(stateSplitter, trackingPathMacroSubstitutor);
    }
}

