/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.EnterPasswordComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasterPasswordDialog
extends DialogWrapper {
    private static final int NUMBER_OF_RETRIES = 5;
    private final JPanel myRootPanel;
    private final EnterPasswordComponent myComponent;
    private int myRetriesCount;

    public MasterPasswordDialog(@NotNull EnterPasswordComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/credentialStore/MasterPasswordDialog", "<init>"));
        }
        super(false);
        this.myComponent = component;
        this.setResizable(false);
        this.myRootPanel = component.getComponent();
        this.setTitle("Password Manager Database Updated");
        this.getOKAction().putValue("Name", "Convert");
        this.getCancelAction().putValue("Name", "Clear Passwords");
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myComponent.getPreferredFocusedComponent();
    }

    @Nullable
    protected String getHelpId() {
        return this.myComponent.getHelpId();
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    public void doOKAction() {
        ValidationInfo info = this.myComponent.apply();
        if (info == null) {
            super.doOKAction();
        } else {
            this.setErrorText(info.message + " " + StringUtil.repeat((String)".", (int)this.myRetriesCount), this.myRootPanel);
            if (info.component != null) {
                info.component.requestFocus();
            }
            if (++this.myRetriesCount > 5) {
                super.doCancelAction();
            }
        }
    }
}

