/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="PasswordSafe", storages={@Storage(value="security.xml", roamingType=RoamingType.DISABLED)})
public class PasswordSafeSettings
implements PersistentStateComponent<State> {
    public static final Topic<PasswordSafeSettingsListener> TOPIC = Topic.create((String)"PasswordSafeSettingsListener", PasswordSafeSettingsListener.class);
    private ProviderType myProviderType = PasswordSafeSettings.getDefaultProviderType();
    String keepassDb;

    private static ProviderType getDefaultProviderType() {
        return SystemInfo.isWindows ? ProviderType.KEEPASS : ProviderType.KEYCHAIN;
    }

    @NotNull
    public ProviderType getProviderType() {
        ProviderType providerType = SystemInfo.isWindows && this.myProviderType == ProviderType.KEYCHAIN ? ProviderType.KEEPASS : this.myProviderType;
        if (providerType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/credentialStore/PasswordSafeSettings", "getProviderType"));
        }
        return providerType;
    }

    public void setProviderType(@NotNull ProviderType value) {
        ProviderType oldValue;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/credentialStore/PasswordSafeSettings", "setProviderType"));
        }
        if (value == ProviderType.DO_NOT_STORE) {
            value = ProviderType.MEMORY_ONLY;
        }
        if (value != (oldValue = this.myProviderType)) {
            this.myProviderType = value;
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                ((PasswordSafeSettingsListener)app.getMessageBus().syncPublisher(TOPIC)).typeChanged(oldValue, value);
            }
        }
    }

    @NotNull
    public State getState() {
        State s = new State();
        s.PROVIDER = this.myProviderType;
        if (this.keepassDb != null && !this.keepassDb.equals(PasswordSafeConfigurableKt.getDefaultKeePassDbFilePath())) {
            s.keepassDb = this.keepassDb;
        }
        State state = s;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/credentialStore/PasswordSafeSettings", "getState"));
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/credentialStore/PasswordSafeSettings", "loadState"));
        }
        this.setProviderType((ProviderType)((Object)ObjectUtils.chooseNotNull((Object)((Object)state.PROVIDER), (Object)((Object)PasswordSafeSettings.getDefaultProviderType()))));
        this.keepassDb = StringUtil.nullize((String)state.keepassDb, (boolean)true);
    }

    static /* synthetic */ ProviderType access$000() {
        return PasswordSafeSettings.getDefaultProviderType();
    }

    public static class State {
        public ProviderType PROVIDER = PasswordSafeSettings.access$000();
        public String keepassDb;
    }
}

