/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerInvocationUtil {
    public static void swingInvokeLater(@Nullable Project project2, @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/debugger/DebuggerInvocationUtil", "swingInvokeLater"));
        }
        if (project2 == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/debugger/DebuggerInvocationUtil", "lambda$swingInvokeLater$0"));
            }
            if (!project2.isDisposed()) {
                runnable2.run();
            }
        });
    }

    public static void invokeLater(@Nullable Project project2, @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/debugger/DebuggerInvocationUtil", "invokeLater"));
        }
        if (project2 != null) {
            ApplicationManager.getApplication().invokeLater(runnable2, project2.getDisposed());
        }
    }

    public static void invokeLater(@Nullable Project project2, @NotNull Runnable runnable2, ModalityState state) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/debugger/DebuggerInvocationUtil", "invokeLater"));
        }
        if (project2 != null) {
            ApplicationManager.getApplication().invokeLater(runnable2, state, project2.getDisposed());
        }
    }

    public static void invokeAndWait(Project project2, @NotNull Runnable runnable2, ModalityState state) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/debugger/DebuggerInvocationUtil", "invokeAndWait"));
        }
        if (project2 != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (runnable2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/debugger/DebuggerInvocationUtil", "lambda$invokeAndWait$1"));
                }
                if (!project2.isDisposed()) {
                    runnable2.run();
                }
            }, state);
        }
    }

    public static <T> T commitAndRunReadAction(Project project2, EvaluatingComputable<T> computable) throws EvaluateException {
        Throwable[] ex = new Throwable[]{null};
        Object result2 = PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            try {
                return computable.compute();
            }
            catch (EvaluateException | RuntimeException e) {
                ex[0] = e;
                return null;
            }
        });
        if (ex[0] != null) {
            if (ex[0] instanceof RuntimeException) {
                throw (RuntimeException)ex[0];
            }
            throw (EvaluateException)ex[0];
        }
        return (T)result2;
    }
}

