/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.attach.XDefaultLocalAttachGroup;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaAttachDebuggerProvider
implements XLocalAttachDebuggerProvider {
    private static final XLocalAttachDebugger ourAttachDebugger = new XLocalAttachDebugger(){

        @Override
        @NotNull
        public String getDebuggerDisplayName() {
            if ("Java Debugger" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1", "getDebuggerDisplayName"));
            }
            return "Java Debugger";
        }

        @Override
        public void attachDebugSession(@NotNull Project project2, @NotNull ProcessInfo processInfo) throws ExecutionException {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1", "attachDebugSession"));
            }
            if (processInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processInfo", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1", "attachDebugSession"));
            }
            Pair address = JavaAttachDebuggerProvider.getAttachAddress(processInfo);
            assert (address != null);
            String name = JavaAttachDebuggerProvider.getAttachString((Pair<String, Integer>)address);
            RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project2).createRunConfiguration(name, ConfigurationTypeUtil.findConfigurationType((String)"Remote").getConfigurationFactories()[0]);
            RemoteConnection remoteConnection = new RemoteConnection(true, (String)address.first, String.valueOf(address.second), false);
            ExecutionEnvironment env = new ExecutionEnvironmentBuilder(project2, DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)runSettings.getConfiguration()).build();
            DefaultDebugEnvironment environment = new DefaultDebugEnvironment(env, (RunProfileState)new RemoteStateState(project2, remoteConnection), remoteConnection, 0L);
            final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(env.getProject()).attachVirtualMachine(environment);
            if (debuggerSession == null) {
                return;
            }
            XDebuggerManager.getInstance((Project)project2).startSessionAndShowTab(name, null, new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session2) {
                    if (session2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1$1", "start"));
                    }
                    JavaDebugProcess javaDebugProcess = JavaDebugProcess.create(session2, debuggerSession);
                    if (javaDebugProcess == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$1$1", "start"));
                    }
                    return javaDebugProcess;
                }
            });
        }
    };
    private static final XLocalAttachGroup ourAttachGroup = new XDefaultLocalAttachGroup(){

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        @NotNull
        public String getGroupName() {
            if ("Java" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2", "getGroupName"));
            }
            return "Java";
        }

        @Override
        @NotNull
        public String getProcessDisplayText(@NotNull Project project2, @NotNull ProcessInfo info, @NotNull UserDataHolder dataHolder) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2", "getProcessDisplayText"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2", "getProcessDisplayText"));
            }
            if (dataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2", "getProcessDisplayText"));
            }
            Pair address = JavaAttachDebuggerProvider.getAttachAddress(info);
            assert (address != null);
            String string = StringUtil.notNullize((String)((String)ArrayUtil.getLastElement((Object[])info.getCommandLine().split(" ")))) + " (" + JavaAttachDebuggerProvider.getAttachString((Pair<String, Integer>)address) + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaAttachDebuggerProvider$2", "getProcessDisplayText"));
            }
            return string;
        }
    };

    private static String getAttachString(Pair<String, Integer> address) {
        return StringUtil.notNullize((String)((String)address.first)) + ":" + address.second;
    }

    @Override
    @NotNull
    public XLocalAttachGroup getAttachGroup() {
        XLocalAttachGroup xLocalAttachGroup = ourAttachGroup;
        if (xLocalAttachGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaAttachDebuggerProvider", "getAttachGroup"));
        }
        return xLocalAttachGroup;
    }

    @Override
    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project2, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/JavaAttachDebuggerProvider", "getAvailableDebuggers"));
        }
        if (processInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processInfo", "com/intellij/debugger/engine/JavaAttachDebuggerProvider", "getAvailableDebuggers"));
        }
        if (contextHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextHolder", "com/intellij/debugger/engine/JavaAttachDebuggerProvider", "getAvailableDebuggers"));
        }
        Pair<String, Integer> address = JavaAttachDebuggerProvider.getAttachAddress(processInfo);
        if (address != null) {
            List<XLocalAttachDebugger> list = Collections.singletonList(ourAttachDebugger);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaAttachDebuggerProvider", "getAvailableDebuggers"));
            }
            return list;
        }
        List<XLocalAttachDebugger> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaAttachDebuggerProvider", "getAvailableDebuggers"));
        }
        return list;
    }

    private static Pair<String, Integer> getAttachAddress(ProcessInfo processInfo) {
        return DebugAttachDetector.getAttachAddress(StringUtil.split((String)processInfo.getCommandLine(), (String)" "));
    }
}

