/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EvaluationContextImpl
implements EvaluationContext {
    private final NullableLazyValue<Value> myThisObject;
    private final SuspendContextImpl mySuspendContext;
    private final StackFrameProxyImpl myFrameProxy;
    private boolean myAutoLoadClasses;
    private ClassLoaderReference myClassLoader;

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, StackFrameProxyImpl frameProxy, @Nullable Value thisObject) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/evaluation/EvaluationContextImpl", "<init>"));
        }
        this.myAutoLoadClasses = true;
        this.myThisObject = NullableLazyValue.createValue(() -> thisObject);
        this.myFrameProxy = frameProxy;
        this.mySuspendContext = suspendContext;
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @NotNull StackFrameProxyImpl frameProxy) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/evaluation/EvaluationContextImpl", "<init>"));
        }
        if (frameProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameProxy", "com/intellij/debugger/engine/evaluation/EvaluationContextImpl", "<init>"));
        }
        this.myAutoLoadClasses = true;
        this.myThisObject = NullableLazyValue.createValue(() -> {
            if (frameProxy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameProxy", "com/intellij/debugger/engine/evaluation/EvaluationContextImpl", "lambda$new$1"));
            }
            try {
                return frameProxy.thisObject();
            }
            catch (EvaluateException evaluateException) {
                return null;
            }
        });
        this.myFrameProxy = frameProxy;
        this.mySuspendContext = suspendContext;
    }

    @Nullable
    public Value getThisObject() {
        return (Value)this.myThisObject.getValue();
    }

    @NotNull
    public SuspendContextImpl getSuspendContext() {
        SuspendContextImpl suspendContextImpl = this.mySuspendContext;
        if (suspendContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/EvaluationContextImpl", "getSuspendContext"));
        }
        return suspendContextImpl;
    }

    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrameProxy;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.getSuspendContext().getDebugProcess();
        if (debugProcessImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/EvaluationContextImpl", "getDebugProcess"));
        }
        return debugProcessImpl;
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.getDebugProcess().getManagerThread();
    }

    public Project getProject() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess.getProject();
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        EvaluationContextImpl copy = new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
        copy.setAutoLoadClasses(this.myAutoLoadClasses);
        return copy;
    }

    @Nullable
    public ClassLoaderReference getClassLoader() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myClassLoader != null) {
            return this.myClassLoader;
        }
        return this.myFrameProxy != null ? this.myFrameProxy.getClassLoader() : null;
    }

    public void setClassLoader(ClassLoaderReference classLoader) {
        this.myClassLoader = classLoader;
    }

    public boolean isAutoLoadClasses() {
        return this.myAutoLoadClasses;
    }

    public void setAutoLoadClasses(boolean autoLoadClasses) {
        this.myAutoLoadClasses = autoLoadClasses;
    }
}

